package com.voxeet.android.media.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.video.Camera2Enumerator;

public class CameraEnumeratorLollipopWrapper implements CameraEnumeratorWrapper {

    private Camera2Enumerator enumerator;
    private Context context;

    private String defaultName;

    public CameraEnumeratorLollipopWrapper(Context context) {
        this.context = context;

        enumerator = new Camera2Enumerator(context);

        defaultName = enumerator.getNameOfFrontFacingDevice();

        if(null == defaultName) {
            defaultName = enumerator.getNameOfBackFacingDevice();
        }
    }

    @Nullable
    @Override
    public String getDefaultName() {
        return defaultName;
    }

    @Override
    public void setDefaultName(@NonNull String defaultName) {
        if(defaultName.equals(enumerator.getNameOfBackFacingDevice())) {
            this.defaultName = defaultName;
        } else if(defaultName.equals(enumerator.getNameOfFrontFacingDevice())) {
            this.defaultName = defaultName;
        }
    }

    @Nullable
    @Override
    public String getNameOfFrontCamera() {
        return enumerator.getNameOfFrontFacingDevice();
    }

    @Nullable
    @Override
    public String getNameOfBackCamera() {
        return enumerator.getNameOfBackFacingDevice();
    }

    @Override
    public boolean isFrontFacing(@Nullable String deviceName) {
        return enumerator.isFrontFacing(deviceName);
    }
}
