/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.json.Event;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="ConferenceStats")
public class ConferenceStats
extends Event {
    private String conference_id;
    private Map<String, Map<String, Infos>> participantStats;

    public String getConference_id() {
        return this.conference_id;
    }

    @Nullable
    public Map<String, Map<String, Infos>> getParticipantStats() {
        return this.participantStats;
    }

    public float getScore(@NonNull String userId) {
        String ownUserId = VoxeetPreferences.id();
        return this.getScore(ownUserId, userId);
    }

    public float getScore(@NonNull String fromUserIdPoV, @NonNull String userId) {
        Infos infos;
        Map<String, Infos> map;
        float score = 0.0f;
        if (this.participantStats.containsKey(fromUserIdPoV) && null != (map = this.participantStats.get(userId)) && map.containsKey(userId) && null != (infos = map.get(userId))) {
            for (Stats stats : infos.stats) {
                score += stats.score;
            }
            score /= (float)Math.max(1, infos.stats.length);
        }
        return score;
    }

    @Nullable
    public Infos getStats(@NonNull String userId) {
        Map<String, Infos> map;
        if (this.participantStats.containsKey(userId) && null != (map = this.participantStats.get(userId)) && map.containsKey(userId)) {
            return map.get(userId);
        }
        return null;
    }

    @Override
    public String getType() {
        return "ConferenceStats";
    }

    public static class Stats {
        public String media;
        public float score;
        public long ssrc;
        public String lastPkt;
        public String firstPkt;
        public double jitter;
        public long lostPkt;
        public double fracLostPkt;
        public long recvBitrate;
        public long recvPkt;
        public long recvOct;
        public int audioLevel;
    }

    public static class Infos {
        public Stats[] stats;
        public boolean master;
        public long estBitrate;
        public long stunRtt;
    }
}

