package com.voxeet.sdk.json.internal;

import android.support.annotation.NonNull;

import java.util.HashMap;

/**
 * Created by kevinleperf on 19/04/2018.
 */

public class ParamsHolder {

    private HashMap<String, Object> values;

    public ParamsHolder() {
        values = new HashMap<>();
    }

    public ParamsHolder(HashMap<String, Object> values) {
        this.values = values;
    }

    /**
     * Set the current conference video codec
     * supported :
     *  - VP8
     *  - H264
     *
     * @param videoCodec see above for possible values
     * @return the current instance
     */
    public ParamsHolder setVideoCodec(@NonNull String videoCodec) {
        return putValue("videoCodec", videoCodec);
    }

    public ParamsHolder putValue(@NonNull String key, Object value) {
        values.put(key, value);
        return this;
    }

    public HashMap<String, Object> build() {
        return values;
    }
}
