/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.localstats;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.stats.LocalStats;
import com.voxeet.android.media.stats.RTCInboundRTPStreamStats;
import com.voxeet.sdk.core.services.localstats.LocalStatsUserTypes;
import com.voxeet.sdk.core.services.localstats.TimePoint;
import com.voxeet.sdk.core.services.localstats.events.LocalStatsUserChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.greenrobot.eventbus.EventBus;

public class LocalStatsUserInfo {
    private static final String TYPE_AUDIO = "audio";
    private static final String TYPE_VIDEO = "video";
    private static final long MAXIMUM_DIFFERENCE_MS = 50000L;
    private static final String TAG = LocalStatsUserInfo.class.getSimpleName();
    private String mUserId;
    private HashMap<String, List<TimePoint>> mPacketReceived;
    private HashMap<String, List<TimePoint>> mBytesReceived;
    private List<TimePoint> mPacketOverallReceived;
    private LocalStatsUserTypes currentType;

    public LocalStatsUserInfo(String userId) {
        this.mUserId = userId;
        this.mPacketReceived = new HashMap();
        this.mBytesReceived = new HashMap();
        this.mPacketOverallReceived = new ArrayList<TimePoint>();
        this.currentType = LocalStatsUserTypes.DEFAULT;
    }

    public void addFromLocalStats(@Nullable LocalStats stats) {
        long added = 0L;
        if (null != stats) {
            List inbounds = stats.getStatsForClass(RTCInboundRTPStreamStats.class);
            for (RTCInboundRTPStreamStats inbound : inbounds) {
                String type = inbound.mediaType;
                if (null == type) continue;
                this.getPacketReceived(type).add(new TimePoint(System.currentTimeMillis(), inbound.packetsReceived));
                this.getBytesReceived(type).add(new TimePoint(System.currentTimeMillis(), inbound.bytesReceived));
                added += inbound.packetsReceived;
            }
        }
        this.mPacketOverallReceived.add(new TimePoint(System.currentTimeMillis(), added));
        this.purge();
        this.checkUserState();
    }

    public LocalStatsUserTypes getCurrentType() {
        return this.currentType;
    }

    public boolean isDisconnected() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.mPacketReceived.keySet());
        if (keys.size() == 0) {
            return true;
        }
        for (String key : keys) {
            if (this.isDisconnected(this.mPacketReceived.get(key))) continue;
            return false;
        }
        return true;
    }

    public boolean isFluctuating() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.mPacketReceived.keySet());
        if (keys.size() == 0) {
            return true;
        }
        for (String key : keys) {
            if (this.isFluctuating(this.mPacketReceived.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean isFluctuating(@Nullable List<TimePoint> list) {
        if (null == list) {
            return false;
        }
        return this.isListDisconnectedForTime(list, 1000L);
    }

    private boolean isDisconnected(@Nullable List<TimePoint> list) {
        if (null == list) {
            return false;
        }
        return this.isListDisconnectedForTime(list, 3000L);
    }

    private boolean isListDisconnectedForTime(@NonNull List<TimePoint> list, long time) {
        long past = System.currentTimeMillis() - time;
        long minPacketCount = -1L;
        long maxPacketCount = -1L;
        boolean treshold = false;
        if (list.size() > 1) {
            for (int index = list.size() - 1; index >= 0 && !treshold; --index) {
                TimePoint point = list.get(index);
                if (point.getTime() > past) {
                    if (minPacketCount == -1L || minPacketCount > point.getPackets()) {
                        minPacketCount = point.getPackets();
                    }
                    if (maxPacketCount >= point.getPackets()) continue;
                    maxPacketCount = point.getPackets();
                    continue;
                }
                treshold = true;
            }
            return minPacketCount < 0L || maxPacketCount <= minPacketCount;
        }
        return true;
    }

    @NonNull
    private List<TimePoint> getPacketReceived(@NonNull String type) {
        return this.getTimeList(type, this.mPacketReceived);
    }

    @NonNull
    private List<TimePoint> getBytesReceived(@NonNull String type) {
        return this.getTimeList(type, this.mBytesReceived);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private List<TimePoint> getTimeList(@NonNull String type, @NonNull HashMap<String, List<TimePoint>> map) {
        HashMap<String, List<TimePoint>> hashMap = map;
        synchronized (hashMap) {
            List<TimePoint> holder = map.get(type);
            if (null == holder) {
                holder = new ArrayList<TimePoint>();
                map.put(type, holder);
            }
            return holder;
        }
    }

    private void purge() {
        this.removeInMap(this.mBytesReceived);
        this.removeInMap(this.mPacketReceived);
        this.removeInList(this.mPacketOverallReceived);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInMap(@NonNull Map<String, List<TimePoint>> map) {
        Map<String, List<TimePoint>> map2 = map;
        synchronized (map2) {
            Set<String> keys = map.keySet();
            for (String key : keys) {
                List<TimePoint> list = map.get(key);
                this.removeInList(list);
            }
        }
    }

    private void removeInList(@NonNull List<TimePoint> list) {
        int i = 0;
        boolean finished = false;
        long maximum_in_past = System.currentTimeMillis() - 50000L;
        while (i < list.size() && !finished) {
            if (list.get(i).getTime() < maximum_in_past) {
                list.remove(i);
                continue;
            }
            finished = true;
            ++i;
        }
    }

    private void checkUserState() {
        boolean isFluctuating;
        boolean isDisconnected = this.isDisconnected();
        LocalStatsUserTypes new_type = this.currentType.next(isDisconnected, isFluctuating = this.isFluctuating());
        if (null != new_type) {
            LocalStatsUserTypes current = this.currentType;
            this.currentType = new_type;
            EventBus.getDefault().post((Object)new LocalStatsUserChangeEvent(this.mUserId, this, current, new_type));
        }
    }
}

