/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.impl;

import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.impl.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.network.ISdkConferenceRService;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.events.success.ConferenceCreationSuccess;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.ConferenceResponse;
import com.voxeet.sdk.models.ConferenceType;
import com.voxeet.sdk.models.impl.DefaultConference;
import com.voxeet.sdk.models.impl.DefaultConferenceUser;
import eu.codlab.simplepromise.Promise;

public class ConferenceSdkService
extends AbstractConferenceSdkService<ISdkConferenceRService, ConferenceSdkObservableProvider> {
    public ConferenceSdkService(VoxeetSdkTemplate instance, long timeout) {
        super(instance, new ConferenceSdkObservableProvider(), timeout, new ServiceProviderHolder.Builder().setRetrofit(instance.getRetrofit()).setService(ISdkConferenceRService.class).setEventBus(instance.getEventBus()).setClient(instance.getClient()).build());
    }

    @Override
    protected Promise<Boolean> onCreateDemoSuccess(ConferenceResponse response) {
        DefaultConference conference = this.createConference();
        conference.setConferenceId(response.getConfId());
        conference.setConferenceType(ConferenceType.DEMO.value());
        String conferenceAlias = response.getConfAlias();
        this.setConference(conference);
        this.setConferenceAlias(conferenceAlias);
        this.getTwig().i("Demo conference created with id: " + conference.getConferenceId(), new Object[0]);
        this.getEventBus().post((Object)new ConferenceCreationSuccess(response.getConfId(), response.getConfAlias()));
        return this.joinVoxeetConference(response.getConfId());
    }

    @Override
    protected DefaultConference createConference() {
        return new DefaultConference();
    }

    @Override
    protected DefaultConferenceUser createConferenceUser(String userId, String device, UserInfo userInfo) {
        return new DefaultConferenceUser(userId, device, userInfo);
    }

    @Override
    protected UserInfo createUserInfo(String userName, String externalId, String avatarUrl) {
        return new UserInfo(userName, externalId, avatarUrl);
    }

    @Override
    protected void startTransactionConferenceUser() {
    }

    @Override
    protected void commitTransactionConferenceUser() {
    }

    @Override
    protected boolean isSDK() {
        return true;
    }

    @Override
    public Promise<Boolean> onCreationSuccess(String conferenceId) {
        return this.joinVoxeetConference(conferenceId);
    }
}

