/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.success.AddConferenceParticipantResultEvent;
import com.voxeet.sdk.events.success.ConferenceRefreshedEvent;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.models.ConferenceUserStatus;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class InvitePromise
extends AbstractPromiseable<List<ConferenceRefreshedEvent>> {
    private final String TAG = InvitePromise.class.getSimpleName();
    private final List<String> ids;
    private final String conferenceId;

    public InvitePromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId, @NonNull List<String> ids) {
        super(parent, mediaService, provider, information, eventBus);
        this.ids = ids;
        this.conferenceId = conferenceId;
    }

    @Override
    @NonNull
    public Promise<List<ConferenceRefreshedEvent>> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<List<ConferenceRefreshedEvent>>(){

            public void onCall(final @NonNull Solver<List<ConferenceRefreshedEvent>> solver) {
                InvitePromise.this.removeTimeoutCallbacks();
                InvitePromise.this.sendTimeoutCallbacks();
                boolean sdk = InvitePromise.this.isSDK();
                ArrayList<String> voxeetIds = sdk ? null : new ArrayList<String>();
                final ArrayList<String> externalIds = new ArrayList<String>();
                externalIds.addAll(InvitePromise.this.ids);
                if (!sdk) {
                    voxeetIds.addAll(InvitePromise.this.ids);
                }
                if (null == InvitePromise.this.conferenceId) {
                    try {
                        throw new IllegalStateException("You're not in a conference");
                    }
                    catch (Exception e) {
                        InvitePromise.this.getEventBus().post((Object)new AddConferenceParticipantResultEvent(InvitePromise.this.getParent().handleError(e), false));
                        solver.reject((Throwable)e);
                        return;
                    }
                }
                Call<ResponseBody> user = InvitePromise.this.getProvider().getInviteObservable(InvitePromise.this.conferenceId, new SdkConferenceInvitation(voxeetIds, externalIds));
                HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        ArrayList<ConferenceRefreshedEvent> list = new ArrayList<ConferenceRefreshedEvent>();
                        InvitePromise.this.getEventBus().post((Object)new AddConferenceParticipantResultEvent(response.code() == 200));
                        try {
                            String body = ((ResponseBody)response.body()).string();
                            Log.d((String)InvitePromise.this.TAG, (String)("onNext: " + body));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (response.code() == 200) {
                            for (String userId : externalIds) {
                                if (userId.equals(VoxeetPreferences.id())) continue;
                                Log.d((String)InvitePromise.this.TAG, (String)("Conference participant with id: " + userId + " invited"));
                                ConferenceRefreshedEvent event = new ConferenceRefreshedEvent(userId, InvitePromise.this.updateConferenceParticipants(userId, ConferenceUserStatus.IN_PROGRESS));
                                InvitePromise.this.getEventBus().post((Object)event);
                                list.add(event);
                            }
                        }
                        solver.resolve(list);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        e.printStackTrace();
                        InvitePromise.this.getEventBus().post((Object)new AddConferenceParticipantResultEvent(InvitePromise.this.getParent().handleError(e), false));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

