package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import com.voxeet.sdk.models.impl.DefaultMeeting;

/**
 * Created by RomainB on 5/23/16.
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEET_READ_TIMESTAMP_UPDATED)
public class MeetingReadTimeStampUpdatedEvent extends Event {

    @JsonProperty("userMeeting")
    private DefaultMeeting meeting;

    public DefaultMeeting getMeeting() {
        return meeting;
    }

    public void setMeeting(DefaultMeeting meeting) {
        this.meeting = meeting;
    }

    @Override
    public String getType() {
        return EventNames.MEET_READ_TIMESTAMP_UPDATED;
    }
}
