/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.models.RecordingStatus;
import com.voxeet.sdk.models.impl.DefaultConference;
import com.voxeet.sdk.models.impl.DefaultConferenceInfos;
import com.voxeet.sdk.models.impl.DefaultConferenceUser;
import com.voxeet.sdk.models.impl.DefaultUserProfile;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="UserInvited")
public class UserInvited
extends Event {
    @JsonProperty(value="conference")
    private DefaultConferenceInfos conferenceInfos;
    private List<DefaultUserProfile> participants;

    public List<DefaultUserProfile> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<DefaultUserProfile> participants) {
        this.participants = participants;
    }

    public DefaultConference getConference() {
        DefaultConference conference = new DefaultConference();
        conference.setConferenceInfos(this.conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(this.conferenceInfos.getConferenceType());
        conference.setMeetingId(this.conferenceInfos.getMeetingId());
        conference.setConferenceId(this.conferenceInfos.getConferenceId());
        conference.setDescription(this.conferenceInfos.getDescription());
        conference.setLocation(this.conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
        for (DefaultUserProfile profile : this.participants) {
            conference.getConferenceUsers().add(new DefaultConferenceUser(profile));
        }
        return conference;
    }

    public DefaultConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return "UserInvited";
    }
}

