/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.information;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.audio.UserPosition;
import com.voxeet.sdk.core.ConferenceSimpleState;
import com.voxeet.sdk.core.abs.information.ConferenceState;
import com.voxeet.sdk.core.abs.information.ConferenceUserType;
import com.voxeet.sdk.models.abs.ConferenceUser;
import com.voxeet.sdk.models.impl.DefaultConference;
import com.voxeet.sdk.models.impl.DefaultParticipant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConferenceInformation {
    private static final String TAG = ConferenceInformation.class.getSimpleName();
    @NonNull
    private DefaultConference mConference;
    @NonNull
    private String mConferenceId = "unknown";
    @NonNull
    private Map<String, String> mUserIdsCached;
    private ConferenceSimpleState mConferenceType;
    @NonNull
    private List<ConferenceUser> mLastInvitationReceived;
    private ConferenceState state = ConferenceState.DEFAULT;
    private HashMap<String, UserPosition> mPositions;
    private boolean mOwnScreenShareStarted = false;
    private boolean mOwnVideoStarted = false;
    private ConferenceUserType mUserType = ConferenceUserType.NORMAL;

    private ConferenceInformation() {
        this.mUserIdsCached = new HashMap<String, String>();
        this.mLastInvitationReceived = new ArrayList<ConferenceUser>();
        this.mConference = new DefaultConference();
        this.mConferenceType = ConferenceSimpleState.NONE;
        this.mPositions = new HashMap();
    }

    public ConferenceInformation(@NonNull String conferenceId) {
        this();
        this.mConferenceId = conferenceId;
        this.mConference.setConferenceId(this.mConferenceId);
    }

    @NonNull
    public UserPosition getPosition(@NonNull ConferenceUser user) {
        return this.getPosition(user.getUserId());
    }

    @NonNull
    public UserPosition getPosition(@NonNull String userId) {
        UserPosition p = this.mPositions.get(userId);
        if (null == p) {
            p = new UserPosition(0.0, 0.0);
        }
        return p;
    }

    public void setPosition(@NonNull ConferenceUser user, @NonNull UserPosition point) {
        this.setPosition(user.getUserId(), point);
    }

    public void setPosition(@NonNull String userId, @NonNull UserPosition point) {
        this.mPositions.put(userId, point);
    }

    @NonNull
    public DefaultConference getConference() {
        return this.mConference;
    }

    public void setConference(@NonNull DefaultConference conference) {
        this.mConference = conference;
    }

    public void setConferenceType(@NonNull ConferenceSimpleState type) {
        this.mConferenceType = type;
    }

    @NonNull
    public ConferenceSimpleState getConferenceType() {
        return this.mConferenceType;
    }

    @NonNull
    public Map<String, String> getUserIdsCached() {
        return this.mUserIdsCached;
    }

    @NonNull
    public List<ConferenceUser> getLastInvitationReceived() {
        return this.mLastInvitationReceived;
    }

    public void setConferenceState(@NonNull ConferenceState state) {
        this.state = state;
    }

    @NonNull
    public ConferenceState getState() {
        return this.state;
    }

    @NonNull
    public ConferenceState getConferenceState() {
        return this.state;
    }

    public void setOwnVideoStarted(boolean ownVideoStarted) {
        Log.d((String)TAG, (String)("setOwnVideoStarted: " + ownVideoStarted));
        this.mOwnVideoStarted = ownVideoStarted;
    }

    public boolean isOwnVideoStarted() {
        Log.d((String)TAG, (String)("isOwnVideoStarted: " + this.mOwnVideoStarted));
        return this.mOwnVideoStarted;
    }

    public void setConferenceUserType(@NonNull ConferenceUserType userType) {
        this.mUserType = userType;
    }

    public ConferenceUserType getConferenceUserType() {
        return this.mUserType;
    }

    public boolean isBroadcaster() {
        return ConferenceUserType.BROADCASTER.equals((Object)this.mUserType);
    }

    public boolean isListener() {
        return ConferenceUserType.LISTENER.equals((Object)this.mUserType);
    }

    public void setLocalUserType(ConferenceUserType userType) {
        this.mUserType = userType;
    }

    public void setScreenShareOn(boolean enable) {
        this.mOwnScreenShareStarted = enable;
    }

    public boolean isScreenShareOn() {
        return this.mOwnScreenShareStarted;
    }

    public void participantsToConferenceUsers(List<DefaultParticipant> participants) {
        if (null != participants) {
            Map<String, String> cache = this.getUserIdsCached();
            for (DefaultParticipant participant : participants) {
                cache.put(participant.getExternalId(), participant.getExternalId());
            }
            DefaultConference conference = this.getConference();
            for (DefaultParticipant participant : participants) {
                conference.updateParticipantToConferenceUsers(participant);
            }
        }
    }
}

