package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import com.voxeet.sdk.models.impl.DefaultScheduleMeeting;

/**
 * Created by RomainB on 5/23/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEET_ACTIVITY_ADDED)
public class MeetActivityAddedEvent extends Event {

    @JsonProperty("scheduledConference")
    private DefaultScheduleMeeting meeting;

    public DefaultScheduleMeeting getMeeting() {
        return meeting;
    }

    public void setMeeting(DefaultScheduleMeeting meeting) {
        this.meeting = meeting;
    }

    @Override
    public String getType() {
        return EventNames.MEET_ACTIVITY_ADDED;
    }
}
