package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.TimeZone;

import com.voxeet.sdk.networking.DeviceType;

@JsonIgnoreProperties(ignoreUnknown = true)
public class GuesstConferenceEvent {

    private String deviceIdentifier;

    private String pincode;

    private DeviceType deviceType;

    private String timezone;

    public GuesstConferenceEvent(String deviceIdentifier, String pincode, DeviceType deviceType) {
        this.deviceIdentifier = deviceIdentifier;
        this.pincode = pincode;
        this.deviceType = deviceType;
        this.timezone = TimeZone.getDefault().getID();
    }

    public String getDeviceIdentifier() {
        return deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getPincode() {
        return pincode;
    }

    public void setPincode(String pincode) {
        this.pincode = pincode;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }
}
