package com.voxeet.sdk.events.success;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaStream;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.abs.ConferenceUser;
import com.voxeet.sdk.models.impl.DefaultConferenceUser;

public class ConferenceUserUpdatedEvent extends SuccessEvent {

    private boolean isScreenShare;

    @NonNull
    private ConferenceUser user;

    @Nullable
    private MediaStream mediaStream;

    public ConferenceUserUpdatedEvent(@NonNull ConferenceUser user) {
        this.user = user;
    }

    public ConferenceUserUpdatedEvent(@NonNull ConferenceUser user, @NonNull MediaStream stream) {
        this(user, stream, false);
    }

    public ConferenceUserUpdatedEvent(@NonNull ConferenceUser user,
                                      @NonNull MediaStream stream,
                                      boolean isScreenShare) {
        this.user = user;
        this.mediaStream = stream;
        this.isScreenShare = isScreenShare;
    }

    @Nullable
    public MediaStream getMediaStream() {
        return mediaStream;
    }

    public boolean isScreenShare() {
        return isScreenShare;
    }

    @NonNull
    public ConferenceUser getUser() {
        return user;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + " " + user + " " + mediaStream;
    }
}
