package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import com.voxeet.sdk.models.Presence;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.USER_LOG_OUT)
public class UserLogoutEvent extends Event {

    String userId;

    Presence presence;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Presence getPresence() {
        return presence;
    }

    public void setPresence(Presence presence) {
        this.presence = presence;
    }

    @Override
    public String getType() {
        return EventNames.USER_LOG_OUT;
    }
}
