package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import com.voxeet.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_PROFILE_UPDATED)
public class OwnProfileUpdated extends Event {

    private String userId;

    private DefaultUserProfile profile;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DefaultUserProfile getProfile() {
        return profile;
    }

    public void setProfile(DefaultUserProfile profile) {
        this.profile = profile;
    }

    @Override
    public String getType() {
        return EventNames.OWN_PROFILE_UPDATED;
    }
}
