package com.voxeet.sdk.events.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.events.error.ConferenceJoinedError;

/**
 * Created by kevinleperf on 07/04/2018.
 */

public class PromiseConferenceJoinedErrorException extends Throwable {

    @Nullable
    private Throwable mException;

    @NonNull
    private ConferenceJoinedError mEvent;

    private PromiseConferenceJoinedErrorException() {

    }

    public PromiseConferenceJoinedErrorException(@NonNull ConferenceJoinedError event,
                                                 @Nullable Throwable exception) {
        this();

        mEvent = event;
        mException = exception;
    }

    @NonNull
    public ConferenceJoinedError getEvent() {
        return mEvent;
    }

    @Nullable
    public Throwable getException() {
        return mException;
    }
}
