/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaCryptoCallback;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.stats.LocalStats;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.VideoSink;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;

public class MediaService
extends AbstractVoxeetService {
    private MediaCryptoCallback mediaCryptoCallback;
    private MediaSDK media;

    public MediaService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    public boolean hasMedia() {
        return null != this.media;
    }

    public MediaSDK getMedia() {
        return this.media;
    }

    @Deprecated
    @Nullable
    public LocalStats getLocalStats(@NonNull String peer) {
        if (null == peer) {
            return null;
        }
        MediaSDK media = this.getMedia();
        if (null != media) {
            return media.getLocalStats(peer);
        }
        return null;
    }

    public void releaseMedia() {
        if (null != this.media) {
            this.media.stop();
        }
        this.media = null;
    }

    public void createMedia(Context context, String userId, MediaEngine.StreamListener mediaStreamListener, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, boolean videoOn, boolean useMic) throws MediaEngineException {
        this.media = new MediaSDK(context, userId, mediaStreamListener, cameraEventsHandler, videoOn, useMic, this.mediaCryptoCallback);
    }

    public EglBase.Context getEglContext() {
        if (null != this.media) {
            return this.media.getEglBase().getEglBaseContext();
        }
        return null;
    }

    public void setCryptoCallback(@Nullable MediaCryptoCallback callback) {
        this.mediaCryptoCallback = callback;
    }

    public boolean attachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        if (null != this.media) {
            this.getMedia().attachMediaStream(videoSink, stream);
        }
        return null != this.media;
    }

    public boolean unAttachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        if (null != this.media) {
            this.getMedia().unattachMediaStream(videoSink, stream);
        }
        return null != this.media;
    }
}

