/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.impl;

import com.voxeet.android.media.peer.SdpDescription;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.network.ISdkConferenceRService;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.CreateConferenceParams;
import voxeet.com.sdk.json.JoinParameters;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartScreenSharingResponse;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopScreenSharingResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.models.CandidatesPush;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.SubscribeConference;

public class ConferenceSdkObservableProvider
extends AbstractConferenceSdkObservableProvider<ISdkConferenceRService> {
    private ISdkConferenceRService mService;

    @Override
    protected ISdkConferenceRService getService() {
        return this.mService;
    }

    @Override
    public Class getRetrofitInjectedClass() {
        return ISdkConferenceRService.class;
    }

    @Override
    public void setRetrofitInstantiatedProvider(ISdkConferenceRService service) {
        this.mService = service;
    }

    @Override
    public Call<ResponseBody> leaveConference(String conferenceId) {
        return this.getService().leaveConference(conferenceId);
    }

    @Override
    public Call<ResponseBody> getDeclineObservable(String conferenceId) {
        return this.getService().decline(conferenceId);
    }

    @Override
    public Call<StartVideoResponse> getStartVideoObservable(String conferenceId, String id) {
        return this.getService().startVideo(conferenceId, id);
    }

    @Override
    public Call<StopVideoResponse> getStopVideoObservable(String conferenceId, String id) {
        return this.getService().stopVideo(conferenceId, id);
    }

    @Override
    public Call<StartScreenSharingResponse> getStartScreenShareObservable(String conferenceId, String id) {
        return this.getService().startScreenShare(conferenceId);
    }

    @Override
    public Call<StopScreenSharingResponse> getStopScreenShareObservable(String conferenceId, String id) {
        return this.getService().stopScreenShare(conferenceId);
    }

    @Override
    public Call<ConferenceResponse> getCreateConferenceObservable(CreateConferenceParams params) {
        return this.getService().createConference(params);
    }

    @Override
    public Call<ConferenceResponse> getCreateDemoObservable() {
        return this.getService().createDemo();
    }

    @Override
    public Call<ResponseBody> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation) {
        return this.getService().invite(conferenceId, sdkConferenceInvitation);
    }

    @Override
    public Call<ReplayConferenceEvent> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody) {
        return this.getService().replay(conferenceId, sdkConferenceReplayBody);
    }

    @Override
    public Call<ResponseBody> getStartRecordingObservable(String conferenceId) {
        return this.getService().startRecording(conferenceId);
    }

    @Override
    public Call<ResponseBody> getStopRecordingObservable(String conferenceId) {
        return this.getService().stopRecording(conferenceId);
    }

    @Override
    public Call<ResponseBody> getLogOutObservable(String token) {
        return this.getService().logout(token);
    }

    @Override
    public Call<GetConferenceStatusEvent> getConferenceStatusObservable(String conferenceId) {
        return this.getService().conferenceStatus(conferenceId);
    }

    @Override
    public Call<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId) {
        return this.getService().conferenceHistory(conferenceId);
    }

    @Override
    public Call<SubscribeConference> getSubscribeObservable(String conferenceId) {
        return this.getService().subscribe(conferenceId);
    }

    @Override
    public Call<ResponseBody> getUnSubscribeObservable(String conferenceId) {
        return this.getService().unSubscribe(conferenceId);
    }

    @Override
    public Call<ResponseBody> getSubscribeForCallObservable(String conferenceId) {
        return this.getService().subscribeForCall(conferenceId);
    }

    @Override
    public Call<ResponseBody> getUnSubscribeFromCallObservable(String conferenceId) {
        return this.getService().unsubscribeFromCall(conferenceId);
    }

    @Override
    public Call<ResumeConference> joinConference(String conferenceId, JoinParameters deviceEvent) {
        return this.getService().joinConference(conferenceId, deviceEvent);
    }

    @Override
    public Call<ResponseBody> answerConference(String conferenceId, String peer, SdpDescription description) {
        return this.getService().answerConference(conferenceId, peer, description);
    }

    @Override
    public Call<ResponseBody> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent) {
        return this.getService().broadcastMessage(conferenceId, broadcastEvent);
    }

    @Override
    public Call<ResponseBody> candidates(String conferenceId, String peerId, CandidatesPush candidates) {
        return this.getService().candidates(conferenceId, peerId, candidates);
    }

    @Override
    public Call<ResponseBody> renegociate(String conferenceId) {
        return this.getService().renegociate(conferenceId);
    }

    @Override
    public Call<ResponseBody> iceRestart(String conferenceId) {
        return this.getService().iceRestart(conferenceId);
    }
}

