/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.error.SubscribeConferenceErrorEvent;
import voxeet.com.sdk.events.success.SubscribeConferenceEvent;
import voxeet.com.sdk.models.SubscribeConference;

public class SubscribeConferenceEventPromiseable
extends AbstractPromiseable<Boolean> {
    public SubscribeConferenceEventPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<SubscribeConference> user = SubscribeConferenceEventPromiseable.this.getProvider().getSubscribeObservable(SubscribeConferenceEventPromiseable.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<SubscribeConference>(){

                    @Override
                    public void onSuccess(@NonNull SubscribeConference object, @NonNull Response<SubscribeConference> response) {
                        SubscribeConferenceEventPromiseable.this.log("You are no subscribed to this mConference's events");
                        SubscribeConferenceEventPromiseable.this.getEventBus().post((Object)new SubscribeConferenceEvent(object));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<SubscribeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        SubscribeConferenceEventPromiseable.this.log("Failed to subscribe to this mConference's events");
                        SubscribeConferenceEventPromiseable.this.getEventBus().post((Object)new SubscribeConferenceErrorEvent(SubscribeConferenceEventPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

