/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.abs.information.ConferenceState;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.ConferenceLeftError;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.promises.NotInConferenceException;
import voxeet.com.sdk.events.success.ConferenceLeftSuccessEvent;
import voxeet.com.sdk.models.impl.DefaultConference;

public class LeavePromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = LeavePromise.class.getSimpleName();

    public LeavePromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    final ConferenceInformation infos = LeavePromise.this.getInformation();
                    if (null == infos) {
                        throw new NotInConferenceException();
                    }
                    final String conferenceId = infos.getConference().getConferenceId();
                    if (null != infos) {
                        infos.setConferenceState(ConferenceState.LEAVING);
                    }
                    final String conferenceAlias = null != infos ? infos.getConference().getConferenceAlias() : "";
                    LeavePromise.this.log("Attempting to leave mConference with mConference id " + conferenceId);
                    LeavePromise.this.closeMedia();
                    Call<ResponseBody> user = LeavePromise.this.getProvider().leaveConference(conferenceId);
                    HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            LeavePromise.this.removeTimeoutCallbacks();
                            Log.d((String)TAG, (String)"Conference left successfully");
                            DefaultConference conference = infos.getConference();
                            int leftInConference = infos.getConference().getConferenceUsers().size() - 1;
                            if (response.code() == 200 || response.code() == 404) {
                                LeavePromise.this.getEventBus().post((Object)new ConferenceLeftSuccessEvent(conferenceId, conferenceAlias, leftInConference));
                                solver.resolve((Object)true);
                            } else {
                                LeavePromise.this.getEventBus().post((Object)new ConferenceLeftError(conferenceId, conferenceAlias, response.code() + ""));
                                solver.resolve((Object)false);
                            }
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            LeavePromise.this.removeTimeoutCallbacks();
                            Log.d((String)TAG, (String)"Something went wrong while leaving the mConference");
                            infos.setConferenceState(ConferenceState.LEFT);
                            LeavePromise.this.getEventBus().post((Object)new ConferenceLeftError(conferenceId, conferenceAlias, LeavePromise.this.getParent().handleError(e)));
                            solver.resolve((Object)false);
                        }
                    });
                }
                catch (NotInConferenceException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }
}

