/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.success.ConferenceUsersInvitedEvent;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class GetConferenceStatus
extends AbstractPromiseable<ConferenceUsersInvitedEvent> {
    public GetConferenceStatus(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<ConferenceUsersInvitedEvent> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<ConferenceUsersInvitedEvent>(){

            public void onCall(final @NonNull Solver<ConferenceUsersInvitedEvent> solver) {
                Call<GetConferenceStatusEvent> user = GetConferenceStatus.this.getProvider().getConferenceStatusObservable(GetConferenceStatus.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<GetConferenceStatusEvent>(){

                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        Iterable users = Iterables.filter(object.getConferenceUsers(), (Predicate)new Predicate<DefaultConferenceUser>(){

                            public boolean apply(DefaultConferenceUser input) {
                                return input.getStatus().equalsIgnoreCase(ConferenceUserStatus.CONNECTING.toString());
                            }
                        });
                        GetConferenceStatus.this.log("Successfully retrieved connecting users");
                        ConferenceUsersInvitedEvent event = new ConferenceUsersInvitedEvent(users);
                        GetConferenceStatus.this.getEventBus().post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceStatus.this.log("Error while retrieving connecting users");
                        GetConferenceStatus.this.getEventBus().post((Object)new ConferenceUsersInvitedEvent(null));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

