package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.GetConferenceHistoryErrorEvent;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.success.GetConferenceHistoryEvent;
import voxeet.com.sdk.models.HistoryConference;

public class GetConferenceHistoryPromiseable extends AbstractPromiseable<GetConferenceHistoryEvent> {

    public GetConferenceHistoryPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<GetConferenceHistoryEvent> createPromise() {
        return new Promise<>(new PromiseSolver<GetConferenceHistoryEvent>() {
            @Override
            public void onCall(@NonNull final Solver<GetConferenceHistoryEvent> solver) {
                final Call<List<HistoryConference>> user = getProvider().getConferenceHistoryObservable(getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<List<HistoryConference>>() {
                    @Override
                    public void onSuccess(@NonNull List<HistoryConference> object, @NonNull Response<List<HistoryConference>> response) {
                        log("Dispatching mConference history response");

                        GetConferenceHistoryEvent event = new GetConferenceHistoryEvent(object);
                        getEventBus().post(event);
                        solver.resolve(event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<List<HistoryConference>> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Error while retrieving mConference history");

                        getEventBus().post(new GetConferenceHistoryErrorEvent(getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}
