/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.audio.AudioRoute;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.voiceengine.WebRtcAudioEffects;
import org.webrtc.voiceengine.WebRtcAudioUtils;
import voxeet.com.sdk.audio.SoundManager;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.json.ConferenceDestroyedPush;
import voxeet.com.sdk.utils.AudioType;

public class AudioService
extends AbstractVoxeetService {
    private static SoundManager sSoundManager;
    private static final String TAG;

    public AudioService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        AudioService.preInitSounds(instance.getApplicationContext());
        instance.getEventBus().register((Object)this);
    }

    @Nullable
    public static SoundManager getSoundManager() {
        return sSoundManager;
    }

    public static boolean preInitSounds(@NonNull Context applicationContext) {
        if (null == sSoundManager) {
            sSoundManager = new SoundManager(applicationContext);
            return true;
        }
        return false;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferencePreJoinedEvent event) {
        this.logWebRtcInfos();
        this.enableAec(true);
        this.enableNoiseSuppressor(true);
        sSoundManager.onConferencePreJoinedEvent();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        sSoundManager.onConferenceDestroyedPush();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return sSoundManager.getAvailableRoutes();
    }

    public AudioRoute currentRoute() {
        return sSoundManager.currentRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        return sSoundManager.setAudioRoute(route);
    }

    public void setSpeakerMode(boolean isSpeaker) {
        sSoundManager.setSpeakerMode(isSpeaker);
    }

    public boolean isSpeakerOn() {
        return sSoundManager.isSpeakerOn();
    }

    public void acquireLocks() {
        sSoundManager.acquireLocks();
    }

    public void releaseLocks() {
        sSoundManager.releaseLocks();
    }

    public void setInVoiceCallSoundType() {
        sSoundManager.setInVoiceCallSoundType();
    }

    public void resetDefaultSoundType() {
        sSoundManager.resetDefaultSoundType();
    }

    public void abandonAudioFocusRequest() {
        sSoundManager.abandonAudioFocusRequest();
    }

    public void requestAudioFocus() {
        sSoundManager.requestAudioFocus();
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return sSoundManager.setSound(type, assetName);
    }

    public void playSoundType(@NonNull AudioType type) {
        sSoundManager.playSoundType(type);
    }

    public void stopSoundType(@NonNull AudioType audioType) {
        sSoundManager.stopSoundType(audioType);
    }

    public void stop() {
        sSoundManager.stop();
    }

    public void enable() {
        sSoundManager.enable();
    }

    public void disable() {
        sSoundManager.disable();
        this.stop();
    }

    public void logWebRtcInfos() {
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: AEC (hw) := " + WebRtcAudioEffects.canUseAcousticEchoCanceler()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: AEC (hw) := call crashed");
        }
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: NS (hw) := " + WebRtcAudioEffects.canUseNoiseSuppressor()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: NS (hw) := call crashed");
        }
        Log.d((String)TAG, (String)("logWebRtcInfos: AEC (WebRTC) := " + WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler()));
        Log.d((String)TAG, (String)("logWebRtcInfos: NS (WebRTC) := " + WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor()));
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: isAcousticEchoCancelerBlacklisted := " + WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: isAcousticEchoCancelerBlacklisted := call crashed");
        }
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: isAcousticEchoCancelerSupported := " + WebRtcAudioEffects.isAcousticEchoCancelerSupported()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: isAcousticEchoCancelerSupported := call crashed");
        }
        Log.d((String)TAG, (String)("logWebRtcInfos: isNoiseSuppressorBlacklisted := " + WebRtcAudioEffects.isNoiseSuppressorBlacklisted()));
        Log.d((String)TAG, (String)("logWebRtcInfos: isNoiseSuppressorSupported := " + WebRtcAudioEffects.isNoiseSuppressorSupported()));
    }

    public void enableAec(boolean enable) {
        boolean blacklisted = WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted();
        boolean checkExcludedUUID = !WebRtcAudioEffects.canUseAcousticEchoCanceler();
        boolean rejected = false;
        try {
            rejected = !WebRtcAudioEffects.isAcousticEchoCancelerSupported() || blacklisted || checkExcludedUUID;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rejected) {
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)enable);
        } else {
            Log.d((String)TAG, (String)"enableAec: do not enableAec, already managed by the Hardware");
        }
    }

    public void enableNoiseSuppressor(boolean enable) {
        boolean checkExcludedUUID = !WebRtcAudioEffects.canUseNoiseSuppressor();
        boolean rejected = false;
        try {
            rejected = !WebRtcAudioEffects.isNoiseSuppressorSupported() || checkExcludedUUID;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rejected) {
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)enable);
        } else {
            Log.d((String)TAG, (String)"enableNoiseSuppressor: do not enableNoiseSuppressor, already managed by the Hardware");
        }
    }

    static {
        TAG = AudioService.class.getSimpleName();
    }
}

