/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.audio.AudioRoute;
import com.voxeet.android.media.sensors.ConferenceLock;
import com.voxeet.android.media.sensors.ProximitySensor;
import com.voxeet.android.media.sensors.ScreenSensor;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.voiceengine.WebRtcAudioEffects;
import org.webrtc.voiceengine.WebRtcAudioUtils;
import voxeet.com.sdk.audio.SoundManager;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.events.success.ConferenceEndedEvent;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.json.ConferenceDestroyedPush;
import voxeet.com.sdk.utils.AudioType;

public class AudioService
extends AbstractVoxeetService {
    private static SoundManager sSoundManager;
    private static final String TAG;
    private boolean isAecSoftEnabled = false;
    private boolean isNSSoftEnabled = false;
    private List<ConferenceLock> locks = new ArrayList<ConferenceLock>();

    public AudioService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        AudioService.preInitSounds(instance.getApplicationContext());
        instance.getEventBus().register((Object)this);
        this.locks.add(new ProximitySensor(instance.getApplicationContext()));
        this.locks.add(new ScreenSensor(instance.getApplicationContext()));
    }

    @Nullable
    public static SoundManager getSoundManager() {
        return sSoundManager;
    }

    public static boolean preInitSounds(@NonNull Context applicationContext) {
        if (null == sSoundManager) {
            sSoundManager = new SoundManager(applicationContext);
            return true;
        }
        return false;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferencePreJoinedEvent event) {
        this.logWebRtcInfos();
        this.enableAec(true);
        this.enableNoiseSuppressor(true);
        this.updateSensors(this.currentRoute());
        sSoundManager.onConferencePreJoinedEvent();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceEndedEvent event) {
        sSoundManager.onConferenceDestroyedPush();
        this.releaseSensors();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        sSoundManager.onConferenceDestroyedPush();
        this.releaseSensors();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return sSoundManager.getAvailableRoutes();
    }

    public AudioRoute currentRoute() {
        return sSoundManager.currentRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        boolean new_switch = sSoundManager.setAudioRoute(route);
        this.updateSensors(this.currentRoute());
        return new_switch;
    }

    public void setSpeakerMode(boolean isSpeaker) {
        sSoundManager.setSpeakerMode(isSpeaker);
        this.updateSensors(this.currentRoute());
    }

    public boolean isBluetoothHeadsetConnected() {
        return sSoundManager.isBluetoothHeadsetConnected();
    }

    public boolean isWiredHeadsetOn() {
        return sSoundManager.isWiredHeadsetOn();
    }

    public boolean isSpeakerOn() {
        return sSoundManager.isSpeakerOn();
    }

    public void acquireLocks() {
        sSoundManager.acquireLocks();
    }

    public void releaseLocks() {
        sSoundManager.releaseLocks();
    }

    public void setInVoiceCallSoundType() {
        sSoundManager.setInVoiceCallSoundType();
    }

    public void resetDefaultSoundType() {
        sSoundManager.resetDefaultSoundType();
    }

    public void abandonAudioFocusRequest() {
        sSoundManager.abandonAudioFocusRequest();
    }

    public void requestAudioFocus() {
        sSoundManager.requestAudioFocus();
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return sSoundManager.setSound(type, assetName);
    }

    public void playSoundType(@NonNull AudioType type) {
        sSoundManager.playSoundType(type);
    }

    public void stopSoundType(@NonNull AudioType audioType) {
        sSoundManager.stopSoundType(audioType);
    }

    public void stop() {
        sSoundManager.stop();
    }

    public void enable() {
        sSoundManager.enable();
    }

    public void disable() {
        sSoundManager.disable();
        this.stop();
    }

    public void updateSensors(@NonNull AudioRoute route) {
        Log.d((String)"ProximitySensor", (String)("updateSensors: " + (Object)((Object)route)));
        for (ConferenceLock lock : this.locks) {
            Log.d((String)"ProximitySensor", (String)("updateSensors: " + (Object)((Object)route) + " " + lock.getClass().getSimpleName() + " " + !route.useProximitySensor() + " " + lock.isProximity()));
            if (!route.useProximitySensor() && lock.isProximity()) {
                lock.release();
                continue;
            }
            lock.acquire();
        }
    }

    public void releaseSensors() {
        Log.d((String)"ProximitySensor", (String)"releaseSensors: ");
        for (ConferenceLock lock : this.locks) {
            lock.release();
        }
    }

    public void logWebRtcInfos() {
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: AEC (hw) := " + WebRtcAudioEffects.canUseAcousticEchoCanceler()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: AEC (hw) := call crashed");
        }
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: NS (hw) := " + WebRtcAudioEffects.canUseNoiseSuppressor()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: NS (hw) := call crashed");
        }
        Log.d((String)TAG, (String)("logWebRtcInfos: AEC (WebRTC) := " + WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler()));
        Log.d((String)TAG, (String)("logWebRtcInfos: NS (WebRTC) := " + WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor()));
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: isAcousticEchoCancelerBlacklisted := " + WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: isAcousticEchoCancelerBlacklisted := call crashed");
        }
        try {
            Log.d((String)TAG, (String)("logWebRtcInfos: isAcousticEchoCancelerSupported := " + WebRtcAudioEffects.isAcousticEchoCancelerSupported()));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"logWebRtcInfos: isAcousticEchoCancelerSupported := call crashed");
        }
        Log.d((String)TAG, (String)("logWebRtcInfos: isNoiseSuppressorBlacklisted := " + WebRtcAudioEffects.isNoiseSuppressorBlacklisted()));
        Log.d((String)TAG, (String)("logWebRtcInfos: isNoiseSuppressorSupported := " + WebRtcAudioEffects.isNoiseSuppressorSupported()));
    }

    public boolean enableAec(boolean enable) {
        boolean blacklisted = WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted();
        boolean checkExcludedUUID = !WebRtcAudioEffects.canUseAcousticEchoCanceler();
        boolean rejected = false;
        try {
            rejected = !WebRtcAudioEffects.isAcousticEchoCancelerSupported() || blacklisted || checkExcludedUUID;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rejected) {
            this.isAecSoftEnabled = enable;
            WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)enable);
            return true;
        }
        Log.d((String)TAG, (String)"enableAec: do not enableAec, already managed by the Hardware");
        return false;
    }

    public boolean isAecSoftEnabled() {
        return this.isAecSoftEnabled;
    }

    public boolean isNSSoftEnabled() {
        return this.isNSSoftEnabled;
    }

    public boolean enableNoiseSuppressor(boolean enable) {
        boolean checkExcludedUUID = !WebRtcAudioEffects.canUseNoiseSuppressor();
        boolean rejected = false;
        try {
            rejected = !WebRtcAudioEffects.isNoiseSuppressorSupported() || checkExcludedUUID;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rejected) {
            this.isNSSoftEnabled = enable;
            WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)enable);
            return true;
        }
        Log.d((String)TAG, (String)"enableNoiseSuppressor: do not enableNoiseSuppressor, already managed by the Hardware");
        return false;
    }

    static {
        TAG = AudioService.class.getSimpleName();
    }
}

