package voxeet.com.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.stats.LocalStats;

import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.VideoRenderer;

import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;

/**
 * Created by kevinleperf on 17/10/2018.
 */

public class MediaService extends AbstractVoxeetService {

    private MediaSDK media;

    public MediaService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    public boolean hasMedia() {
        return null != media;
    }

    public MediaSDK getMedia() {
        return media;
    }

    /**
     * @deprecated use {@link LocalStatsService#getLocalStats(String)}
     * @param peer
     * @return
     */
    @Deprecated
    @Nullable
    public LocalStats getLocalStats(@NonNull String peer) {
        MediaSDK media = getMedia();
        if (null != media) return media.getLocalStats(peer);
        return null;
    }

    public void releaseMedia() {
        if (null != media) media.stop();

        media = null;
    }

    public void createMedia(Context context, String userId, MediaEngine.StreamListener mediaStreamListener,
                            CameraVideoCapturer.CameraEventsHandler cameraEventsHandler,
                            boolean videoOn, boolean useMic) throws MediaEngineException {
        media = new MediaSDK(context, userId, mediaStreamListener, cameraEventsHandler, videoOn, useMic);
    }

    public EglBase.Context getEglContext() {
        if (null != media) {
            return media.getEglBase().getEglBaseContext();
        } else {
            return null;
        }
    }

    public boolean attachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (null != media) getMedia().attachMediaStream(render, stream);
        return null != media;
    }

    public boolean unAttachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (null != media) getMedia().unattachMediaStream(render, stream);
        return null != media;
    }
}
