package voxeet.com.sdk.core.network;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface ISdkVideoPresentationRService {

    @POST("/v1/conferences/{confId}/videopresentation/start")
    Call<ResponseBody> startVideoPresentation(@Path("confId") String conferenceId,
                                              @Body VideoPresentationUrl url);


    @POST("/v1/conferences/{confId}/videopresentation/stop")
    Call<ResponseBody> stopVideoPresentation(@Path("confId") String conferenceId);


    @POST("/v1/conferences/{confId}/filepresentation/play")
    Call<ResponseBody> playVideoPresentation(@Path("confId") String conferenceId);

    @POST("/v1/conferences/{confId}/filepresentation/pause")
    Call<ResponseBody> pauseVideoPresentation(@Path("confId") String conferenceId,
                                              @Body VideoPresentationSeek body);

    @POST("/v1/conferences/{confId}/filepresentation/seek")
    Call<ResponseBody> seekVideoPresentation(@Path("confId") String conferenceId,
                                             @Body VideoPresentationSeek body);


    public class VideoPresentationUrl {
        public String url;

        private VideoPresentationUrl() {

        }

        public VideoPresentationUrl(String url) {
            this();

            this.url = url;
        }
    }

    public class VideoPresentationSeek {
        public long timestamp;

        private VideoPresentationSeek() {

        }

        public VideoPresentationSeek(long timestamp) {
            this();

            this.timestamp = timestamp;
        }
    }
}
