package voxeet.com.sdk.utils;

/**
 * Created by kevinleperf on 08/10/2018.
 */

public class Sound {
    private int id;
    private String name;
    private boolean loaded;
    private boolean play;
    private boolean loop;
    private boolean unload;
    private int streamId;

    private Sound() {
        loop = false;
        play = false;
        loaded = false;
        unload = false;
    }

    public Sound(String name) {
        this();

        this.name = name;
        this.loaded = false;
    }

    public Sound(String name, int id, boolean loaded) {
        this(name);

        this.name = name;
        this.id = id;
        this.loaded = loaded;
    }

    public String getName() {
        return name;
    }

    public Sound setLoaded(boolean b) {
        loaded = b;
        return this;
    }

    public Sound setId(int i) {
        id = i;
        return this;
    }

    public int getSoundId() {
        return id;
    }

    public boolean isLoaded() {
        return loaded;
    }

    public Sound setPlay(boolean b) {
        play = b;
        return this;
    }

    public boolean isToPlay() {
        return play;
    }

    public Sound setLoop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public boolean isLoop() {
        return loop;
    }

    public Sound unload() {
        unload = true;
        return this;
    }

    public boolean isUnloaded() {
        return unload;
    }

    public Sound setStreamId(int streamId) {
        this.streamId = streamId;
        return this;
    }

    public int getStreamId() {
        return streamId;
    }
}
