/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.stats.LocalStats;
import org.webrtc.EglBase;
import org.webrtc.VideoRenderer;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;

public class MediaService
extends AbstractVoxeetService {
    private MediaSDK media;

    public MediaService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    public boolean hasMedia() {
        return null != this.media;
    }

    public MediaSDK getMedia() {
        return this.media;
    }

    @Deprecated
    @Nullable
    public LocalStats getLocalStats(@NonNull String peer) {
        MediaSDK media = this.getMedia();
        if (null != media) {
            return media.getLocalStats(peer);
        }
        return null;
    }

    public void releaseMedia() {
        if (null != this.media) {
            this.media.stop();
        }
        this.media = null;
    }

    public void createMedia(Context context, String userId, MediaEngine.StreamListener mediaStreamListener, boolean videoOn, boolean useMic) throws MediaEngineException {
        this.media = new MediaSDK(context, userId, mediaStreamListener, videoOn, useMic);
    }

    public EglBase.Context getEglContext() {
        if (null != this.media) {
            return this.media.getEglBase().getEglBaseContext();
        }
        return null;
    }

    public boolean attachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (null != this.media) {
            this.getMedia().attachMediaStream(render, stream);
        }
        return null != this.media;
    }

    public boolean unAttachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (null != this.media) {
            this.getMedia().unattachMediaStream(render, stream);
        }
        return null != this.media;
    }
}

