/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import okhttp3.WebSocket;
import voxeet.com.sdk.core.VoxeetDispatcher;
import voxeet.com.sdk.core.VoxeetHttp;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.websocket.ConnectListener;
import voxeet.com.sdk.core.network.websocket.SocketListener;
import voxeet.com.sdk.core.network.websocket.WebSocketProxy;
import voxeet.com.sdk.core.services.authenticate.WebSocketState;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.utils.Twig;

public class VoxeetWebSocket {
    private static final String TAG = VoxeetWebSocket.class.getSimpleName();
    private Twig twig;
    static final String SOCKET_ERROR = "SOCKET_ERROR";
    static final String SOCKET_MESSAGE = "SOCKET_TEXT";
    static final String SOCKET_CONNECTED = "SOCKET_CONNECTED";
    static final String SOCKET_DISCONNECTED = "SOCKET_DISCONNECTED";
    static final String SOCKET_STATE_CHANGE = "SOCKET_STATE_CHANGE";
    private Context context;
    private String socketUrl;
    private WebSocketProxy mWebSocketProxy;
    private List<ConnectListener> mConnectListeners;
    private ConnectListener mConnectListener;
    private SocketListener listener = new SocketListener(){

        @Override
        public void onConnect(WebSocket webSocket) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_CONNECTED, "Connected");
        }

        @Override
        public void onTextMessage(String message) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_MESSAGE, message);
        }

        @Override
        public void onError(HttpException exception) {
            exception.printStackTrace();
            if (null != exception.getResponse()) {
                try {
                    Log.d((String)TAG, (String)("onError: http exception for socket (message) " + exception.getResponse().message()));
                    Log.d((String)TAG, (String)("onError: http exception for socket (body) " + exception.getResponse().body().toString()));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_ERROR, "Error " + exception.getMessage());
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onStateChanged(WebSocketState newState) {
            Log.d((String)TAG, (String)("onStateChanged: newState:=" + (Object)((Object)newState)));
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_STATE_CHANGE, newState.name());
        }

        @Override
        public void onDisconnected() {
            VoxeetWebSocket.this.twig.e("Websocket disconnect by server", new Object[0]);
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_DISCONNECTED, "on Disconnected by server: ");
        }
    };

    public VoxeetWebSocket(Context context, VoxeetSdkTemplate sdk, @NonNull String socketUrl) {
        this.context = context;
        this.twig = sdk.getTwig();
        this.socketUrl = socketUrl;
        this.mConnectListeners = new ArrayList<ConnectListener>();
        this.mConnectListener = new ConnectListener(){

            @Override
            public void onConnect(WebSocket websocket) {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onConnect(websocket);
                }
            }

            @Override
            public void onConnectError(HttpException e) {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onConnectError(e);
                }
            }

            @Override
            public void onNoNetwork() {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onNoNetwork();
                }
            }
        };
    }

    public void connect(@NonNull VoxeetHttp provider) {
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.removeListeners();
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
        }
        this.createProxy();
        this.mWebSocketProxy.connect(provider, this.mConnectListener);
    }

    private void clear() {
        VoxeetDispatcher.dispatch(SOCKET_STATE_CHANGE, WebSocketState.CLOSED.name());
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
            this.mWebSocketProxy.removeListener(this.listener);
            this.mWebSocketProxy.removeListeners();
        }
        this.mWebSocketProxy = null;
    }

    private void createProxy() {
        this.mWebSocketProxy = new WebSocketProxy(this.context, this.socketUrl);
        this.mWebSocketProxy.addListener(this.listener);
    }

    public void close(boolean set_disconnect) {
        this.clear();
    }

    public boolean isOpen() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }

    private boolean sendPing() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.sendPing();
    }

    public boolean isInit() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }
}

