/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.audio;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.audio.AudioRoute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import voxeet.com.sdk.utils.AudioType;
import voxeet.com.sdk.utils.SoundPool;
import voxeet.com.sdk.utils.Validate;

public class SoundManager {
    private com.voxeet.android.media.audio.AudioManager mAudioManager;
    private MediaPowerManager mMediaPowerManager;
    private Context mContext;
    private AudioManager mSystemAudioService;
    private int mSoundMode;
    private int mSoundType = Integer.MIN_VALUE;
    private SoundPool _sound_pool;
    private HashMap<AudioType, String> mSounds;
    private boolean mEnable;

    private SoundManager() {
        this.enable();
    }

    public SoundManager(@NonNull Context context) {
        this();
        this.mSoundMode = 0;
        this.mAudioManager = new com.voxeet.android.media.audio.AudioManager(context);
        this.mMediaPowerManager = new MediaPowerManager(context, this.currentRoute());
        this.mContext = context;
        this.mSystemAudioService = (AudioManager)this.mContext.getSystemService("audio");
        this.mSounds = new HashMap();
        this.configure();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return this.mAudioManager.availableRoutes();
    }

    public AudioRoute currentRoute() {
        return this.mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        this.mAudioManager.setOutputRoute(route);
        return true;
    }

    public SoundManager setSpeakerMode(boolean isSpeaker) {
        this.mAudioManager.setSpeakerMode(isSpeaker);
        return this;
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals((Object)this.mAudioManager.outputRoute());
    }

    public SoundManager acquireLocks() {
        this.mMediaPowerManager.acquire();
        return this;
    }

    public SoundManager releaseLocks() {
        this.mMediaPowerManager.release();
        return this;
    }

    public SoundManager setInVoiceCallSoundType() {
        this.mAudioManager.forceVolumeControlStream(this.mSoundMode);
        return this;
    }

    public SoundManager resetDefaultSoundType() {
        this.mAudioManager.forceVolumeControlStream(this.mAudioManager.getDefaultSoundStreamType());
        return this;
    }

    private int getUiSoundsStreamType() {
        try {
            Method method = this.mSystemAudioService.getClass().getDeclaredMethod("getUiSoundsStreamType", new Class[0]);
            Object result = method.invoke((Object)this.mSystemAudioService, new Object[0]);
            return (Integer)result;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return 1;
    }

    private void forceVolumeControlStream(int type) {
        try {
            Method method = this.mSystemAudioService.getClass().getDeclaredMethod("forceVolumeControlStream", Integer.TYPE);
            method.invoke((Object)this.mSystemAudioService, type);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public SoundManager abandonAudioFocusRequest() {
        this.mAudioManager.abandonAudioFocusRequest();
        return this;
    }

    public SoundManager requestAudioFocus() {
        this.mAudioManager.requestAudioFocus();
        return this;
    }

    private SoundPool getSoundPool() {
        if (this._sound_pool == null) {
            this._sound_pool = new SoundPool(this.mContext, this.mSoundMode);
        }
        return this._sound_pool;
    }

    private void configure() {
        this.mSounds.put(AudioType.RING, "out.mp3");
        this.mSounds.put(AudioType.HANGUP, "leave.mp3");
        this.setSound(AudioType.RING, this.mSounds.get((Object)AudioType.RING));
        this.setSound(AudioType.HANGUP, this.mSounds.get((Object)AudioType.HANGUP));
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return this.getSoundPool().release(type).setShortResource(type, assetName);
    }

    public SoundManager playSoundType(@NonNull AudioType type) {
        if (this.isEnabled()) {
            this.getSoundPool().playShortResource(type, this.mSounds.get((Object)type));
        }
        return this;
    }

    public SoundManager playSoundTypeForce(@NonNull AudioType type) {
        this.getSoundPool().playShortResource(type, this.mSounds.get((Object)type));
        return this;
    }

    public SoundManager stopSoundType(@NonNull AudioType audioType) {
        this.getSoundPool().stop(audioType);
        return this;
    }

    public SoundManager stop() {
        this.getSoundPool().stop();
        return this;
    }

    public SoundManager onConferencePreJoinedEvent() {
        this.mSoundType = this.getUiSoundsStreamType();
        this.requestAudioFocus();
        return this;
    }

    public SoundManager onConferenceDestroyedPush() {
        if (Integer.MIN_VALUE != this.mSoundType) {
            // empty if block
        }
        this.abandonAudioFocusRequest();
        return this;
    }

    public void enable() {
        this.mEnable = true;
    }

    public void disable() {
        this.mEnable = false;
    }

    private boolean isEnabled() {
        return this.mEnable;
    }
}

