package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.UPDATE_PROFILE)
public class UpdateProfileEvent extends Event {

    private String userId;

    private String nickName;

    private String firstName;

    private String lastName;

    private String statusPhrase;

    private String company;

    private String jobTitle;

    private String city;

    private String country;

    public UpdateProfileEvent(String userId, String firstName, String lastName, String nickName, String statusPhrase, String jobTitle, String country, String city, String company) {

        this.userId = userId;

        this.firstName = firstName;

        this.lastName = lastName;

        this.nickName = nickName;

        this.country = country;

        this.jobTitle = jobTitle;

        this.statusPhrase = statusPhrase;

        this.city = city;

        this.company = company;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getStatusPhrase() {
        return statusPhrase;
    }

    public void setStatusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
    }

    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getType() {
        return EventNames.UPDATE_PROFILE;
    }
}
