package com.voxeet.android.media.sensors;

import android.content.Context;
import android.os.PowerManager;
import android.support.annotation.NonNull;

public class ScreenSensor implements ConferenceLock {
    private PowerManager mPowerManager;
    private Context mContext;
    private PowerManager.WakeLock mProximityWakeLock;

    private ScreenSensor() {

    }

    public ScreenSensor(@NonNull Context context) {
        this();
        mContext = context;

        mPowerManager = (PowerManager) mContext.getSystemService(Context.POWER_SERVICE);

        mProximityWakeLock = mPowerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "ProximitySensor:");
    }

    @Override
    public void acquire() {
        try {
            if (null != mProximityWakeLock && !mProximityWakeLock.isHeld()) {
                mProximityWakeLock.acquire();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void release() {
        try {
            if (null != mProximityWakeLock && mProximityWakeLock.isHeld()) {
                mProximityWakeLock.release();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isProximity() {
        return false;
    }
}
