/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.sensors;

import android.content.Context;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import com.voxeet.android.media.sensors.ConferenceLock;

public class ScreenSensor
implements ConferenceLock {
    private PowerManager mPowerManager;
    private Context mContext;
    private PowerManager.WakeLock mProximityWakeLock;

    private ScreenSensor() {
    }

    public ScreenSensor(@NonNull Context context) {
        this();
        this.mContext = context;
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mProximityWakeLock = this.mPowerManager.newWakeLock(1, "ProximitySensor:");
    }

    @Override
    public void acquire() {
        try {
            if (null != this.mProximityWakeLock && !this.mProximityWakeLock.isHeld()) {
                this.mProximityWakeLock.acquire();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void release() {
        try {
            if (null != this.mProximityWakeLock && this.mProximityWakeLock.isHeld()) {
                this.mProximityWakeLock.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isProximity() {
        return false;
    }
}

