package voxeet.com.sdk.events.success;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

import voxeet.com.sdk.events.BaseEvent;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.SdkParticipant;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class GetConferenceStatusEvent extends BaseEvent {

    @Nullable
    private String conferenceId;

    @Nullable
    private String aliasId;

    private long startTimestamp;

    @JsonProperty("isLive")
    private boolean live;

    @Nullable
    private String type;

    @Nullable
    private List<SdkParticipant> participants;

    public List<DefaultConferenceUser> getConferenceUsers() {
        List<DefaultConferenceUser> users = new ArrayList<>();
        try {
            if (null != participants) {
                for (SdkParticipant participant : participants) {
                    DefaultConferenceUser user = new DefaultConferenceUser(participant.getUserId(),
                            null,
                            new voxeet.com.sdk.json.UserInfo(
                                    participant.getMetadata().getExternalName(),
                                    participant.getMetadata().getExternalId(),
                                    participant.getMetadata().getExternalPhotoUrl()
                            )
                    );
                    user.setConferenceStatusToString(participant.getStatus());
                    user.setStatus(participant.getStatus());
                    user.setConferenceStatus(ConferenceUserStatus.valueOf(participant.getStatus()));
                    users.add(user);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return users;
    }

    @Nullable
    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(@Nullable String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @Nullable
    public String getAliasId() {
        return aliasId;
    }

    public void setAliasId(@Nullable String aliasId) {
        this.aliasId = aliasId;
    }

    public long getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isLive() {
        return live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    @Nullable
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setParticipants(@Nullable List<SdkParticipant> participants) {
        this.participants = participants;
    }
}
