package voxeet.com.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import voxeet.com.sdk.events.SuccessEvent;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AddTagsAnswerEvent extends SuccessEvent {

    private boolean success;

    public AddTagsAnswerEvent(boolean isSuccessful) {
        this.success = isSuccessful;
    }

    public AddTagsAnswerEvent(boolean isSuccessful, String error) {
        super(error);

        this.success = isSuccessful;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}
