/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import voxeet.com.sdk.core.ConferenceSimpleState;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.abs.information.ConferenceState;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.success.ConferenceCreationSuccess;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.models.impl.DefaultConference;

public class JoinPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = JoinPromise.class.getSimpleName();
    private final String conferenceId;
    private final boolean listener;
    private final VoxeetSdkTemplate instance;

    public JoinPromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull VoxeetSdkTemplate instance, @NonNull String conferenceId, boolean listener) {
        super(parent, mediaService, provider, information, eventBus);
        this.instance = instance;
        this.conferenceId = conferenceId;
        this.listener = listener;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        final Promise promise = new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                boolean init_done;
                JoinPromise.this.joinLock();
                Log.d((String)TAG, (String)("Listener mode set to " + JoinPromise.this.listener));
                ConferenceInformation information = JoinPromise.this.createOrSetConferenceWithParams(JoinPromise.this.conferenceId, null);
                information.setListener(JoinPromise.this.listener);
                String currentConferenceId = JoinPromise.this.getParent().getConferenceId();
                ConferenceInformation holder = JoinPromise.this.getConferenceInformation(JoinPromise.this.conferenceId);
                boolean bl = init_done = null != holder && (ConferenceState.JOINING.equals((Object)holder.getConferenceState()) || ConferenceState.JOINED.equals((Object)holder.getConferenceState()));
                if (null != currentConferenceId && currentConferenceId.equals(JoinPromise.this.conferenceId) && init_done) {
                    Log.d((String)TAG, (String)("onCall: join the conference " + JoinPromise.this.conferenceId + " // invalid call ! already calling it"));
                    Log.d((String)TAG, (String)("onCall: btw, the current " + JoinPromise.this.conferenceId + " state is := " + (Object)((Object)holder.getConferenceState())));
                    solver.resolve((Object)true);
                    JoinPromise.this.joinUnlock();
                    return;
                }
                JoinPromise.this.setIsInConference(true);
                DefaultConference conference = holder.getConference();
                Log.d((String)TAG, (String)("Attempting to join conference alias:=" + conference.getConferenceAlias() + " conferenceId:=" + JoinPromise.this.conferenceId));
                Log.d((String)TAG, (String)"onNext: having conference");
                JoinPromise.this.getEventBus().post((Object)new ConferencePreJoinedEvent(JoinPromise.this.conferenceId, conference.getConferenceAlias()));
                information.setConferenceState(ConferenceState.JOINING);
                information.setConferenceType(ConferenceSimpleState.CONFERENCE);
                Log.d((String)TAG, (String)("onNext: join with := " + conference.getConferenceId() + " " + conference.getConferenceAlias()));
                JoinPromise.this.joinUnlock();
                JoinPromise.this.getEventBus().post((Object)new ConferenceCreationSuccess(JoinPromise.this.conferenceId, conference.getConferenceAlias()));
                JoinPromise.this.setCurrentConferenceIfNotInPreviousConference(information);
                JoinPromise.this.joinConference(information).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve((Object)false);
                    }
                });
            }
        });
        if (this.instance.isSocketOpen()) {
            return promise;
        }
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)"onCall: joining but the socket is disconnected");
                JoinPromise.this.instance.logCurrentlySelectedUserWithChain().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                        Log.d((String)TAG, (String)("onCall: connection ? " + result));
                        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

                            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                Log.d((String)TAG, (String)("onCall: join ok? " + result));
                                solver.resolve((Object)result);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(@NonNull Throwable error) {
                                Log.d((String)TAG, (String)"onError: join ko");
                                solver.reject(error);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }
}

