package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.WHISPER_INVITATION_ACCEPTED)
public class WhisperInvitationAccepted extends Event {

    private String conferenceId;

    private String from;

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public String getType() {
        return EventNames.WHISPER_INVITATION_ACCEPTED;
    }
}
