package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Created by Thomas on 20/10/2015.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.VIDEO_PRESENTATION_STOPPED)
public class VideoPresentationStopped extends Event {

    private String key;

    private String conferenceId;

    private String userId;

    public VideoPresentationStopped() {

    }

    public VideoPresentationStopped(String key, String conferenceId, String userId) {
        this();
        setKey(key);
        setConferenceId(conferenceId);
        setUserId(userId);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getKey() {
        return key;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public String getUserId() {
        return userId;
    }

    @Override
    public String getType() {
        return EventNames.VIDEO_PRESENTATION_STOPPED;
    }
}
