package voxeet.com.sdk.events.success;

import android.support.annotation.Nullable;

import voxeet.com.sdk.events.SuccessEvent;

/**
 * Created by RomainBenmansour on 4/18/16.
 */
public class ConferenceLeftSuccessEvent extends SuccessEvent {
    private String conferenceAlias;
    private String conferenceId;
    private boolean remainInConferenceRoom;

    private int remainingUsers;

    public ConferenceLeftSuccessEvent(boolean remainInConferenceRoom) {
        this.remainInConferenceRoom = remainInConferenceRoom;

        this.remainingUsers = -1;
    }

    public ConferenceLeftSuccessEvent() {
        remainInConferenceRoom = false;
    }

    public ConferenceLeftSuccessEvent(@Nullable String conferenceId, @Nullable String conferenceAlias, int usersLeft) {
        remainingUsers = usersLeft;
        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
    }

    public String getConferenceAlias() {
        return conferenceAlias;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public int getRemainingUsers() {
        return remainingUsers;
    }

    public boolean isRemainInConferenceRoom() {
        return remainInConferenceRoom;
    }

    public void setRemainInConferenceRoom(boolean remainInConferenceRoom) {
        this.remainInConferenceRoom = remainInConferenceRoom;
    }
}
