package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.android.media.MediaEngineException;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.promises.NotInConferenceException;
import voxeet.com.sdk.events.success.StopScreenShareAnswerEvent;
import voxeet.com.sdk.json.StopScreenSharingResponse;

public class StopScreenSharePromise extends AbstractPromiseable<Boolean> {
    private final static String TAG = StopScreenSharePromise.class.getSimpleName();

    public StopScreenSharePromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                try {
                    ConferenceInformation information = getInformation();

                    if (null == information || !getParent().isInConference()) {
                        Log.d(TAG, "stopVideo: not in conf");

                        if (getMediaService().hasMedia()) getMediaService().getMedia().stopVideo();
                        throw new NotInConferenceException();
                    }
                    String conferenceId = information.getConference().getConferenceId();

                    if (!isInConference()) {
                        Log.d(TAG, "stopScreenShare: not in conf");

                        if (hasMedia()) getMedia().stopScreenCapturer();
                        throw new NotInConferenceException();
                    }

                    if (!hasMedia()) {
                        Log.d(TAG, "stopScreenShare: media is null");
                        throw new MediaEngineException("media is null");
                    }

                    getMedia().stopScreenCapturer();

                    final Call<StopScreenSharingResponse> stopVideo = getProvider().getStopScreenShareObservable(conferenceId, VoxeetPreferences.id());
                    HttpHelper.enqueue(stopVideo, new HttpCallback<StopScreenSharingResponse>() {
                        @Override
                        public void onSuccess(@NonNull StopScreenSharingResponse object, @NonNull Response<StopScreenSharingResponse> response) {
                            getMedia().stopScreenCapturer();

                            information.setScreenShareOn(false);

                            final StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(true);
                            getEventBus().post(event);
                            createVideoAnswer(object.getUserId(), object.getDescription(), object.getCandidates())
                                    .then(new PromiseExec<Boolean, Object>() {
                                        @Override
                                        public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                            //TODO check for possible call in the createVideoAnswer (callback ?)
                                            solver.resolve(true);
                                        }
                                    })
                                    .error(new ErrorPromise() {
                                        @Override
                                        public void onError(Throwable error) {
                                            error.printStackTrace();
                                            //TODO check for possible call in the createVideoAnswer (callback ?)
                                            solver.resolve(true);
                                        }
                                    });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StopScreenSharingResponse> response) {
                            HttpException.dumpErrorResponse(response);

                            e.printStackTrace();

                            information.setScreenShareOn(false);

                            StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(false);
                            getEventBus().post(event);
                            solver.reject(e);
                        }
                    });
                } catch (MediaEngineException exception) {
                    solver.reject(exception);
                } catch (NotInConferenceException exception) {
                    solver.reject(exception);
                } catch (Exception exception) {
                    solver.reject(exception);
                }
            }
        });
    }
}
