package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.GetConferenceStatusErrorEvent;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class GetConferenceStatusPromiseable  extends AbstractPromiseable<GetConferenceStatusEvent> {

    public GetConferenceStatusPromiseable(@NonNull AbstractConferenceSdkService parent,
                                          @NonNull MediaService mediaService,
                                          @NonNull AbstractConferenceSdkObservableProvider provider,
                                          @Nullable ConferenceInformation information,
                                          @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<GetConferenceStatusEvent> createPromise() {
        return new Promise<>(new PromiseSolver<GetConferenceStatusEvent>() {
            @Override
            public void onCall(@NonNull final Solver<GetConferenceStatusEvent> solver) {
                final Call<GetConferenceStatusEvent> user = getProvider().getConferenceStatusObservable(getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<GetConferenceStatusEvent>() {
                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        try {
                            if (null != response && null != object.getConferenceUsers()) {
                                for (DefaultConferenceUser conferenceUser : object.getConferenceUsers()) {
                                    log(conferenceUser.getUserId() + " / " + conferenceUser.getStatus());
                                }
                                log("Dispatching mConference status result");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        getEventBus().post(object);
                        solver.resolve(object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Error while getting mConference history");
                        e.printStackTrace();

                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(getParent().handleError(e));
                            getEventBus().post(event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, e);
                        } catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject(exception);
                        }
                    }
                });
            }
        });
    }
}
