package voxeet.com.sdk.core.abs.information;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import voxeet.com.sdk.core.ConferenceSimpleState;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultParticipant;

/**
 * Created by kevinleperf on 29/08/2018.
 */

public class ConferenceInformation {

    private static final String TAG = ConferenceInformation.class.getSimpleName();

    @NonNull
    private DefaultConference mConference;

    @NonNull
    private String mConferenceId;

    @NonNull
    private Map<String, String> mUserIdsCached;

    private ConferenceSimpleState mConferenceType;

    @NonNull
    private List<DefaultConferenceUser> mLastInvitationReceived;
    private ConferenceState state = ConferenceState.DEFAULT;

    private boolean mOwnScreenShareStarted;
    private boolean mOwnVideoStarted;
    private boolean mListener;

    private ConferenceInformation() {
        mListener = false;
        mConferenceId = "unknown";
        mUserIdsCached = new HashMap<>();
        mLastInvitationReceived = new ArrayList<>();
        mConference = new DefaultConference();
        mConferenceType = ConferenceSimpleState.NONE;
        mOwnVideoStarted = false;
        mOwnScreenShareStarted = false;

    }

    public ConferenceInformation(@NonNull String conferenceId) {
        this();

        mConferenceId = conferenceId;
        mConference.setConferenceId(mConferenceId);
    }

    @NonNull
    public DefaultConference getConference() {
        return mConference;
    }

    public void setConference(@NonNull DefaultConference conference) {
        mConference = conference;
    }

    public void setConferenceType(@NonNull ConferenceSimpleState type) {
        mConferenceType = type;
    }

    @NonNull
    public ConferenceSimpleState getConferenceType() {
        return mConferenceType;
    }

    @NonNull
    public Map<String, String> getUserIdsCached() {
        return mUserIdsCached;
    }

    @NonNull
    public List<DefaultConferenceUser> getLastInvitationReceived() {
        return mLastInvitationReceived;
    }

    public void setConferenceState(@NonNull ConferenceState state) {
        this.state = state;
    }

    @NonNull
    public ConferenceState getState() {
        return state;
    }

    @NonNull
    public ConferenceState getConferenceState() {
        return state;
    }

    /**
     * Set if the user asked for video in this conference state
     * Helpful to deal with new privacy features in Android P+
     *
     * @param ownVideoStarted a boolean indicating the proper state
     */
    public void setOwnVideoStarted(boolean ownVideoStarted) {
        Log.d(TAG, "setOwnVideoStarted: " + ownVideoStarted);
        mOwnVideoStarted = ownVideoStarted;
    }

    /**
     * Return if the user asked for video in this conference state
     * Helpful to deal with new privacy features in Android P+
     *
     * @return a boolean indicating the proper state
     */
    public boolean isOwnVideoStarted() {
        Log.d(TAG, "isOwnVideoStarted: " + mOwnVideoStarted);
        return mOwnVideoStarted;
    }

    public boolean isListener() {
        return mListener;
    }

    /**
     * Must be done on init
     * <p>
     * Any call afterward to this won't only be used when the "join" will be reused
     * <p>
     * It is should usefull if a user will switch from any mode to the other with proper leave -> join
     *
     * @param listener the state to use
     */
    public void setListener(boolean listener) {
        mListener = listener;
    }

    public void setScreenShareOn(boolean enable) {
        mOwnScreenShareStarted = enable;
    }

    public boolean isScreenShareOn() {
        return mOwnScreenShareStarted;
    }


    public void participantsToConferenceUsers(List<DefaultParticipant> participants) {
        if (null != participants) {
            Map<String, String> cache = getUserIdsCached();
            for (DefaultParticipant participant : participants) {
                cache.put(participant.getExternalId(), participant.getExternalId());
            }

            DefaultConference conference = getConference();
            for (DefaultParticipant participant : participants) {
                conference.updateParticipantToConferenceUsers(participant);
            }
        }
    }
}
