/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.error.SubscribeForCallConferenceErrorEvent;
import voxeet.com.sdk.events.success.SubscribeForCallConferenceAnswerEvent;

public class SubscribeForCallStartPromiseable
extends AbstractPromiseable<Boolean> {
    public SubscribeForCallStartPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ResponseBody> call = SubscribeForCallStartPromiseable.this.getProvider().getSubscribeForCallObservable(SubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(call, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        SubscribeForCallStartPromiseable.this.log("You are no subscribed to receive events when this conf starts");
                        SubscribeForCallStartPromiseable.this.getEventBus().post((Object)new SubscribeForCallConferenceAnswerEvent(SubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId()));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        SubscribeForCallStartPromiseable.this.log("Failed to subscribe to this mConference's start");
                        SubscribeForCallStartPromiseable.this.getEventBus().post((Object)new SubscribeForCallConferenceErrorEvent(SubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId(), SubscribeForCallStartPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

