/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.error.SdkLogoutErrorEvent;
import voxeet.com.sdk.events.success.SdkLogoutSuccessEvent;

public class LogoutPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = LogoutPromise.class.getSimpleName();

    public LogoutPromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                final String id = VoxeetPreferences.id();
                if (null != id) {
                    Log.d((String)TAG, (String)"Attempting to logout");
                    Call<ResponseBody> user = LogoutPromise.this.getProvider().getLogOutObservable(VoxeetPreferences.token());
                    HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200) {
                                String message = "Logout success";
                                Log.d((String)TAG, (String)message);
                                VoxeetPreferences.onLogout();
                                LogoutPromise.this.getVoxeetSDK().closeSocket();
                                LogoutPromise.this.getVoxeetSDK().cleanUserSession(id);
                                LogoutPromise.this.getEventBus().post((Object)new SdkLogoutSuccessEvent(message));
                                solver.resolve((Object)true);
                            } else {
                                String message = "Logout failed";
                                Log.d((String)TAG, (String)message);
                                VoxeetPreferences.onLogout();
                                LogoutPromise.this.getVoxeetSDK().closeSocket();
                                LogoutPromise.this.getVoxeetSDK().cleanUserSession(id);
                                LogoutPromise.this.getEventBus().post((Object)new SdkLogoutErrorEvent(message));
                                solver.resolve((Object)false);
                            }
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            String message = "Logout failed";
                            Log.d((String)TAG, (String)message);
                            VoxeetPreferences.onLogout();
                            LogoutPromise.this.getVoxeetSDK().closeSocket();
                            LogoutPromise.this.getVoxeetSDK().cleanUserSession(id);
                            LogoutPromise.this.getEventBus().post((Object)new SdkLogoutErrorEvent(LogoutPromise.this.getParent().handleError(e)));
                            solver.reject(e);
                        }
                    });
                } else {
                    String message = "Already logged out";
                    Log.d((String)TAG, (String)"Already logged out");
                    LogoutPromise.this.getEventBus().post((Object)new SdkLogoutSuccessEvent("Already logged out"));
                    solver.resolve((Object)true);
                }
            }
        });
    }
}

