/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.android.media.audio.AudioRoute;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.video.Camera2Enumerator;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.VideoRenderer;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.ConferenceSimpleState;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.ConferenceServiceHelper;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.abs.information.ConferenceInformationHolder;
import voxeet.com.sdk.core.abs.information.ConferenceState;
import voxeet.com.sdk.core.abs.promises.CreateConferencePromiseable;
import voxeet.com.sdk.core.abs.promises.DeclinePromise;
import voxeet.com.sdk.core.abs.promises.GetConferenceHistoryPromiseable;
import voxeet.com.sdk.core.abs.promises.GetConferenceStatus;
import voxeet.com.sdk.core.abs.promises.GetConferenceStatusPromiseable;
import voxeet.com.sdk.core.abs.promises.InvitePromise;
import voxeet.com.sdk.core.abs.promises.JoinPromise;
import voxeet.com.sdk.core.abs.promises.LeavePromise;
import voxeet.com.sdk.core.abs.promises.LogoutPromise;
import voxeet.com.sdk.core.abs.promises.ReplayPromise;
import voxeet.com.sdk.core.abs.promises.SendBroadcastMessagePromise;
import voxeet.com.sdk.core.abs.promises.StartRecordingPromiseable;
import voxeet.com.sdk.core.abs.promises.StartScreensharePromise;
import voxeet.com.sdk.core.abs.promises.StartVideoPromise;
import voxeet.com.sdk.core.abs.promises.StopRecordingPromiseable;
import voxeet.com.sdk.core.abs.promises.StopScreenSharePromise;
import voxeet.com.sdk.core.abs.promises.StopVideoPromise;
import voxeet.com.sdk.core.abs.promises.SubscribeConferenceEventPromiseable;
import voxeet.com.sdk.core.abs.promises.SubscribeForCallStartPromiseable;
import voxeet.com.sdk.core.abs.promises.UnsubscribeConferenceEventPromiseable;
import voxeet.com.sdk.core.abs.promises.UnsubscribeForCallStartPromiseable;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.core.services.AudioService;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.core.services.SdkConferenceService;
import voxeet.com.sdk.core.services.TimeoutRunnable;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.events.error.CameraSwitchErrorEvent;
import voxeet.com.sdk.events.error.ConferenceCreatedError;
import voxeet.com.sdk.events.error.ConferenceJoinedError;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.error.ParticipantAddedErrorEvent;
import voxeet.com.sdk.events.error.PermissionRefusedEvent;
import voxeet.com.sdk.events.promises.InConferenceException;
import voxeet.com.sdk.events.promises.NotInConferenceException;
import voxeet.com.sdk.events.promises.PromiseConferenceJoinedErrorException;
import voxeet.com.sdk.events.promises.PromiseParticipantAddedErrorEventException;
import voxeet.com.sdk.events.success.CameraSwitchSuccessEvent;
import voxeet.com.sdk.events.success.ConferenceCreationSuccess;
import voxeet.com.sdk.events.success.ConferenceDestroyedPushEvent;
import voxeet.com.sdk.events.success.ConferenceEndedEvent;
import voxeet.com.sdk.events.success.ConferenceJoinedSuccessEvent;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceRefreshedEvent;
import voxeet.com.sdk.events.success.ConferenceStatsEvent;
import voxeet.com.sdk.events.success.ConferenceUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUserAddedEvent;
import voxeet.com.sdk.events.success.ConferenceUserCallDeclinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserLeftEvent;
import voxeet.com.sdk.events.success.ConferenceUserQualityUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUserUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUsersInvitedEvent;
import voxeet.com.sdk.events.success.DeclineConferenceResultEvent;
import voxeet.com.sdk.events.success.GetConferenceHistoryEvent;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.IncomingCallEvent;
import voxeet.com.sdk.events.success.InvitationReceived;
import voxeet.com.sdk.events.success.OfferCreatedEvent;
import voxeet.com.sdk.events.success.OwnConferenceStartedEvent;
import voxeet.com.sdk.events.success.ParticipantAddedEvent;
import voxeet.com.sdk.events.success.ParticipantUpdatedEvent;
import voxeet.com.sdk.events.success.QualityIndicators;
import voxeet.com.sdk.events.success.QualityUpdatedEvent;
import voxeet.com.sdk.events.success.RecordingStatusUpdate;
import voxeet.com.sdk.events.success.RenegociationEndedEvent;
import voxeet.com.sdk.events.success.RenegociationUpdate;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.events.success.ScreenStreamAddedEvent;
import voxeet.com.sdk.events.success.ScreenStreamRemovedEvent;
import voxeet.com.sdk.events.success.SocketConnectEvent;
import voxeet.com.sdk.events.success.StartVideoAnswerEvent;
import voxeet.com.sdk.factories.VoxeetIntentFactory;
import voxeet.com.sdk.json.ConferenceStats;
import voxeet.com.sdk.json.ConferenceUserAdded;
import voxeet.com.sdk.json.InvitationReceivedEvent;
import voxeet.com.sdk.json.JoinParameters;
import voxeet.com.sdk.json.OfferCreated;
import voxeet.com.sdk.json.RecordingStatusUpdateEvent;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.json.internal.MetadataHolder;
import voxeet.com.sdk.json.internal.ParamsHolder;
import voxeet.com.sdk.models.CandidatesPush;
import voxeet.com.sdk.models.ConferenceQuality;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.ConferenceType;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.NormalConferenceResponse;
import voxeet.com.sdk.models.OfferCandidate;
import voxeet.com.sdk.models.OfferDescription;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.abs.ConferenceUser;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultInvitation;
import voxeet.com.sdk.networking.DeviceType;
import voxeet.com.sdk.utils.ConferenceListener;
import voxeet.com.sdk.utils.Twig;
import voxeet.com.sdk.utils.Validate;

public abstract class AbstractConferenceSdkService<T, COP extends AbstractConferenceSdkObservableProvider<T>>
extends AbstractVoxeetService<T>
implements SdkConferenceService,
ConferenceListener {
    private static final String TAG = AbstractConferenceSdkService.class.getSimpleName();
    private final VoxeetSdkTemplate mInstance;
    private VoxeetSdkTemplate mSDK;
    private ConferenceListener mListener;
    private AbstractConferenceSdkObservableProvider mConferenceObservableProvider;
    private Twig mTwig;
    private EventBus mEventBus;
    private boolean isRecording = false;
    private boolean mInConference = false;
    private long mTimeOutTimer = -1L;
    private HashMap<String, MediaStream> mapOfStreams = new HashMap();
    private HashMap<String, MediaStream> mapOfScreenShareStreams = new HashMap();
    private ReentrantLock joinLock = new ReentrantLock();
    @Nullable
    private String mDefaultCamera;
    private boolean isDefaultOnSpeaker;
    private String mConferenceId = null;
    private ConferenceInformationHolder mConferenceInformationHolder = new ConferenceInformationHolder();
    private Context mContext;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private MediaEngine.StreamListener mediaStreamListener = new MediaEngine.StreamListener(){

        public void onStreamAdded(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamAdded: stream for peer " + peer));
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.getTwig().i("New mConference user joined with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
                    AbstractConferenceSdkService.this.mapOfStreams.put(peer, stream);
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.updateConferenceParticipants(peer, ConferenceUserStatus.ON_AIR);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("New mConference user joined with id: " + user.getUserId(), new Object[0]);
                        if (!peer.equalsIgnoreCase(VoxeetPreferences.id()) && AbstractConferenceSdkService.this.mTimeOutTimer != -1L) {
                            AbstractConferenceSdkService.this.mTwig.i("Cancelling timeout timer", new Object[0]);
                            AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        }
                        AbstractConferenceSdkService.this.updateConferenceFromUsers();
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream added");
                    }
                }
            });
        }

        public void onStreamUpdated(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamUpdated: screen for peer " + peer));
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.getTwig().i("Conference user updated with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
                    AbstractConferenceSdkService.this.getTwig().i("stream updated having video ? " + (stream.videoTracks().size() > 0) + " screenshare := " + stream.isScreenShare(), new Object[0]);
                    if (stream.isScreenShare().booleanValue()) {
                        AbstractConferenceSdkService.this.mapOfScreenShareStreams.put(peer, stream);
                    } else {
                        AbstractConferenceSdkService.this.mapOfStreams.put(peer, stream);
                    }
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.findUserById(peer);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("Conference user updated with id: " + user.getUserId(), new Object[0]);
                        AbstractConferenceSdkService.this.updateConferenceFromUsers();
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream updated");
                    }
                }
            });
        }

        public void onStreamRemoved(final @NonNull String peer) {
            Log.d((String)TAG, (String)"onStreamRemoved: OnStreamRemoved");
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.onUserLeft(peer);
                }
            });
        }

        public void onScreenStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onScreenStreamAdded: screen for peer " + peer));
            AbstractConferenceSdkService.this.getTwig().i("(for ScreenShare) Conference user updated with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
            AbstractConferenceSdkService.this.getTwig().i("screenshare stream updated having video ? " + stream.videoTracks().size() + " :: has stream inside ? " + (stream.videoTracks().size() > 0), new Object[0]);
            AbstractConferenceSdkService.this.mapOfScreenShareStreams.put(peer, stream);
            AbstractConferenceSdkService.this.mEventBus.post((Object)new ScreenStreamAddedEvent(peer, stream));
        }

        public void onScreenStreamRemoved(@NonNull String peer) {
            AbstractConferenceSdkService.this.getTwig().i("Screen share stream removed: " + peer, new Object[0]);
            AbstractConferenceSdkService.this.mapOfScreenShareStreams.remove(peer);
            AbstractConferenceSdkService.this.mEventBus.post((Object)new ScreenStreamRemovedEvent(peer));
        }

        public void onShutdown() {
        }

        public void onIceCandidateDiscovered(String peer, SdpCandidate[] candidates) {
            if (null == AbstractConferenceSdkService.this.getConferenceId()) {
                return;
            }
            Call<ResponseBody> call = AbstractConferenceSdkService.this.mConferenceObservableProvider.candidates(AbstractConferenceSdkService.this.getConferenceId(), peer, new CandidatesPush(candidates));
            call.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    Log.d((String)TAG, (String)"onResponse: Candidates sent ");
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                }
            });
        }
    };
    private CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        public void onCameraError(String s) {
            Log.d((String)TAG, (String)"onCameraError: error...");
            AbstractConferenceSdkService.this.stopVideo().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: stopped video after camera issue " + result));
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }

        public void onCameraDisconnected() {
            Log.d((String)TAG, (String)"onCameraDisconnected");
        }

        public void onCameraFreezed(String s) {
            Log.d((String)TAG, (String)("onCameraFreezed: " + s));
        }

        public void onCameraOpening(String s) {
            Log.d((String)TAG, (String)("onCameraOpening: " + s));
        }

        public void onFirstFrameAvailable() {
            Log.d((String)TAG, (String)"onFirstFrameAvailable");
        }

        public void onCameraClosed() {
            Log.d((String)TAG, (String)"onCameraClosed");
        }
    };
    private boolean isDefaultMute = false;
    private boolean isICERestartEnabled = false;

    public AbstractConferenceSdkService(VoxeetSdkTemplate instance, COP conference_observable_provider, long timeout, @NonNull ServiceProviderHolder<T> holder) {
        super(instance, holder);
        this.mInstance = instance;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mDefaultCamera = new Camera2Enumerator(instance.getApplicationContext()).getNameOfFrontFacingDevice();
        } else {
            Camera1Enumerator enumerator = new Camera1Enumerator(false);
            String[] names = enumerator.getDeviceNames();
            if (null != names && names.length > 0) {
                for (String name : names) {
                    if (!enumerator.isFrontFacing(name)) continue;
                    this.mDefaultCamera = name;
                }
            }
        }
        this.mConferenceObservableProvider = conference_observable_provider;
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider(this.getService());
        this.mListener = instance;
        this.mSDK = instance;
        this.mTimeOutTimer = timeout;
        this.mTwig = instance.getTwig();
        this.mEventBus = EventBus.getDefault();
        this.mContext = instance.getApplicationContext();
        this.setDefaultBuiltInSpeaker(true);
        this.register();
    }

    @Deprecated
    public boolean muteConference(boolean mute) {
        return this.mute(mute);
    }

    @Override
    public boolean mute(boolean mute) {
        if (this.getMediaService().hasMedia()) {
            if (!mute && this.getMediaService().getMedia().isMuted()) {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getTwig().i("No permission for mic... please check it", new Object[0]);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                this.getTwig().i("Conference unmuted", new Object[0]);
                this.getAudioService().setInVoiceCallSoundType();
                this.getMedia().unMute();
            } else if (mute) {
                this.getTwig().i("Conference muted", new Object[0]);
                this.getAudioService().setInVoiceCallSoundType();
                this.getMedia().mute();
            }
        }
        return true;
    }

    @Override
    public boolean isMuted() {
        return this.getMedia() != null && this.getMedia().isMuted();
    }

    @Override
    public boolean isUserMuted(String userId) {
        DefaultConferenceUser user = this.findUserById(userId);
        return user != null && user.isMuted();
    }

    @Override
    public void setListenerMode(boolean isListener) {
        if (this.getMediaService().hasMedia()) {
            MediaSDK media = this.getMediaService().getMedia();
            if (media.isMuted()) {
                media.unMute();
            } else {
                media.mute();
            }
            this.getAudioService().setInVoiceCallSoundType();
        }
    }

    @Override
    @Deprecated
    public boolean attachMediaStream(@NonNull MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.getMediaService().hasMedia()) {
            this.getMedia().attachMediaStream(render, stream);
        }
        return this.getMediaService().hasMedia();
    }

    @Override
    @Deprecated
    public boolean unAttachMediaStream(@NonNull MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.getMediaService().hasMedia()) {
            this.getMedia().unattachMediaStream(render, stream);
        }
        return this.getMediaService().hasMedia();
    }

    @Override
    public void register() {
        this.registerEventBus();
    }

    @Override
    public void unregister() {
        this.unRegisterEventBus();
    }

    public void setDefaultCamera(String cameraName) {
        this.mDefaultCamera = cameraName;
    }

    @Override
    public void toggleVideo() {
        Promise<Boolean> promise = this.isVideoOn() ? this.stopVideo() : this.startVideo();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggleVideo " + result));
            }
        }).error(ConferenceServiceHelper.manageError());
    }

    public void toggleScreenShare() {
        if (this.isScreenShareOn()) {
            this.stopScreenShare().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onSuccess: toggleScreenShare " + result));
                }
            }).error(ConferenceServiceHelper.manageError());
        } else {
            this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
        }
    }

    @Override
    public String getCurrentConferenceId() {
        return this.mConferenceId;
    }

    @Override
    public int getConferenceRoomSize() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != information) {
            return information.getConference().getConferenceRoomSize();
        }
        return 0;
    }

    @Override
    public String currentSpeaker() {
        DefaultConference conference = this.getConference();
        if (!this.hasMedia() || conference == null) {
            return VoxeetPreferences.id();
        }
        String currentSpeaker = null;
        for (DefaultConferenceUser user : conference.getConferenceUsers()) {
            if (user.getUserId() == null || user.getUserId().equals(VoxeetPreferences.id()) || !ConferenceUserStatus.ON_AIR.equals((Object)user.getConferenceStatus())) continue;
            double peerVuMeter = this.getMedia().getPeerVuMeter(user.getUserId());
            if (currentSpeaker != null && (!(peerVuMeter > 0.001) || !(this.getMedia().getPeerVuMeter(currentSpeaker) < peerVuMeter))) continue;
            currentSpeaker = user.getUserId();
        }
        return currentSpeaker;
    }

    @NonNull
    private String currentUserOrEmpty() {
        String currentUserId = VoxeetPreferences.id();
        return null != currentUserId ? currentUserId : "";
    }

    @Override
    public double getSdkPeerVuMeter(@Nullable String peerId) {
        Validate.runningOnUiThread();
        return this.hasMedia() && null != peerId ? this.getMedia().getPeerVuMeter(peerId) : 0.0;
    }

    public DefaultConferenceUser findUserById(String userId) {
        DefaultConference conference = this.getConference();
        return null != conference ? conference.findUserById(userId) : null;
    }

    @Override
    public String getAliasId() {
        DefaultConference conference = this.getConference();
        return null != conference ? conference.getConferenceAlias() : null;
    }

    @Override
    public String getConferenceId() {
        return this.mConferenceId;
    }

    @Deprecated
    public List<AudioRoute> getAvailableRoutes() {
        return this.getAudioService().getAvailableRoutes();
    }

    @Deprecated
    public AudioRoute currentRoute() {
        return this.getAudioService().currentRoute();
    }

    @Override
    @Nullable
    public EglBase.Context getEglContext() {
        return this.getMediaService().getEglContext();
    }

    @Override
    public long getTimeout() {
        return this.mTimeOutTimer;
    }

    @Override
    public void toggleRecording() {
        Promise<Boolean> promise = this.isRecording ? this.stopRecording() : this.startRecording();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggle done " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    @Override
    public boolean muteUser(@NonNull String userId, boolean shouldMute) {
        Validate.runningOnUiThread();
        DefaultConferenceUser user = this.findUserById(userId);
        if (user != null) {
            this.getTwig().i("Setting mute property for mConference participant with id " + userId + " to " + shouldMute, new Object[0]);
            this.startTransactionConferenceUser();
            user.setMuted(shouldMute);
            this.getMedia().changePeerGain(userId, shouldMute ? 10000.0f : 1.0f);
            this.commitTransactionConferenceUser();
        }
        return user != null;
    }

    @Deprecated
    public boolean isVideoOn() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isOwnVideoStarted();
    }

    @Deprecated
    public boolean isScreenShareOn() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isScreenShareOn();
    }

    @Deprecated
    public boolean setAudioRoute(AudioRoute route) {
        return this.getAudioService().setAudioRoute(route);
    }

    public boolean setDefaultMute(boolean default_state) {
        this.isDefaultMute = default_state;
        return true;
    }

    public boolean setDefaultBuiltInSpeaker(boolean default_state) {
        this.isDefaultOnSpeaker = default_state;
        VoxeetPreferences.setDefaultBuiltInSpeakerOn(default_state);
        return true;
    }

    @Override
    public boolean setTimeOut(long timeout) {
        this.getTwig().i("Timeout set to " + timeout, new Object[0]);
        this.mTimeOutTimer = timeout;
        return true;
    }

    @Override
    public boolean setUserPosition(String userId, double angle, double distance) {
        if (this.hasMedia()) {
            this.getMedia().changePeerPosition(userId, angle, distance);
        }
        return this.hasMedia();
    }

    @NonNull
    public ConferenceSimpleState getConferenceType() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information || null == this.mConferenceId) {
            return ConferenceSimpleState.NONE;
        }
        return information.getConferenceType();
    }

    @Nullable
    public DefaultConference getConference() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return null;
        }
        return information.getConference();
    }

    @NonNull
    private DefaultConference getOrSetConference(@NonNull String conferenceId) {
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        if (null != information) {
            return information.getConference();
        }
        Log.d((String)TAG, (String)("getOrSetConference: INVALID CALL FOR GET OR SET CONFERENCE WITH " + conferenceId));
        return new DefaultConference();
    }

    public boolean isInConference() {
        return this.mInConference;
    }

    protected void setIsInConference(boolean status) {
        this.mInConference = status;
    }

    public double getPeerVuMeter(@Nullable String peerId) {
        Validate.runningOnUiThread();
        if (this.hasMedia() && null != peerId) {
            return this.getMedia().getPeerVuMeter(peerId);
        }
        return 0.0;
    }

    @Override
    @NonNull
    public List<DefaultConferenceUser> getConferenceUsers() {
        DefaultConference conference = this.getConference();
        if (null == conference) {
            Log.d((String)TAG, (String)"getConferenceUsers: returning a new instance :: NOT IN A CONFERENCE");
            return new ArrayList<DefaultConferenceUser>();
        }
        return conference.getConferenceUsers();
    }

    @NonNull
    public List<DefaultConferenceUser> getLastInvitationUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return new ArrayList<DefaultConferenceUser>();
        }
        return information.getLastInvitationReceived();
    }

    @Override
    public boolean isLive() {
        return null != this.getConference();
    }

    @Override
    public boolean isListenerMode() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        return null != information && information.isListener();
    }

    @Nullable
    public ConferenceUser getUser(final String userId) {
        DefaultConference conference = this.getConference();
        if (null != conference) {
            return (ConferenceUser)Iterables.find((Iterable)conference.getConferenceUsers(), (Predicate)new Predicate<ConferenceUser>(){

                public boolean apply(ConferenceUser input) {
                    return userId.equals(input.getUserId());
                }
            }, null);
        }
        return null;
    }

    @Deprecated
    @NonNull
    public HashMap<String, MediaStream> getMapOfStreams() {
        return this.mapOfStreams;
    }

    @Deprecated
    @NonNull
    public HashMap<String, MediaStream> getMapOfScreenShareStreams() {
        return this.mapOfScreenShareStreams;
    }

    public AbstractConferenceSdkService<T, COP> cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }

    protected abstract Promise<Boolean> onCreateDemoSuccess(ConferenceResponse var1);

    @Override
    public Promise<Boolean> listenConference(@NonNull String conferenceId) {
        return this.join(conferenceId, true);
    }

    @Override
    public Promise<DeclineConferenceResultEvent> decline(String conferenceId) {
        return new DeclinePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId).createPromise();
    }

    public void sendRequestStartScreenShare() {
        this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
    }

    public void onUserCanceledScreenShare() {
        ConferenceInformation information;
        if (this.hasMedia()) {
            this.getMedia().stopScreenCapturer();
        }
        if (null != (information = this.getCurrentConferenceInformation())) {
            information.setScreenShareOn(false);
        }
    }

    public Promise<Boolean> startScreenShare(@NonNull Intent intent, int width, int height) {
        return new StartScreensharePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), intent, width, height).createPromise();
    }

    public Promise<Boolean> stopScreenShare() {
        return new StopScreenSharePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> startVideo() {
        return new StartVideoPromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> stopVideo() {
        return new StopVideoPromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    protected Promise<Boolean> createVideoAnswer(final String userId, final OfferDescription offerDescription, final List<OfferCandidate> offerCandidates) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)("createVideoAnswer: " + userId + " " + offerDescription.getSdp() + " " + offerDescription.getType()));
                Log.d((String)"SDKMEDIA", (String)("createVideoAnswer: " + userId + " " + offerDescription.getSdp() + " " + offerDescription.getType()));
                try {
                    if (!AbstractConferenceSdkService.this.hasMedia()) {
                        throw new MediaEngineException("media is null");
                    }
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                SdpDescription description = new SdpDescription(offerDescription.getType(), offerDescription.getSdp());
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                if (offerCandidates != null) {
                    for (OfferCandidate candidate : offerCandidates) {
                        candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                    }
                }
                try {
                    AbstractConferenceSdkService.this.getMedia().createAnswerForPeer(userId, description.getSsrc(), description, candidates, VoxeetPreferences.id().equalsIgnoreCase(userId), new PendingPeerCallback(){

                        @Override
                        public void onMessage(@Nullable SdpMessage message) {
                            Log.d((String)TAG, (String)("onMessage: having a message " + message));
                            AbstractConferenceSdkService.this.answer(userId, message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onSuccess: " + result));
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    if (error instanceof PromiseParticipantAddedErrorEventException) {
                                        AbstractConferenceSdkService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                    } else {
                                        error.printStackTrace();
                                    }
                                    solver.resolve((Object)false);
                                }
                            });
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    @Override
    public Promise<ConferenceResponse> create() {
        return this.create(null, null, null);
    }

    public Promise<ConferenceResponse> create(@Nullable MetadataHolder metadata, @Nullable ParamsHolder params) {
        return this.create(null, metadata, params);
    }

    public Promise<ConferenceResponse> create(@Nullable String conferenceAlias) {
        return this.create(conferenceAlias, null, null);
    }

    public Promise<ConferenceResponse> create(@Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder paramsholder) {
        return new CreateConferencePromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), conferenceAlias, metadata, paramsholder).createPromise();
    }

    @Override
    public Promise<Boolean> join(@NonNull String conferenceId) {
        return this.join(conferenceId, false);
    }

    private Promise<Boolean> join(@NonNull String conferenceId, boolean listener) {
        Log.d((String)TAG, (String)("join: joining conference " + conferenceId + " listener:=" + listener));
        return new JoinPromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), this.mInstance, conferenceId, listener).createPromise();
    }

    protected Promise<ResumeConference> extendedJoin(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<ResumeConference>(){

            public void onCall(final @NonNull Solver<ResumeConference> solver) {
                AbstractConferenceSdkService.this.setIsInConference(true);
                AbstractConferenceSdkService.this.mConferenceId = conferenceId;
                ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                Call<ResumeConference> observable = AbstractConferenceSdkService.this.mConferenceObservableProvider.joinConference(conferenceId, new JoinParameters(DeviceType.ANDROID, information.isListener()));
                HttpHelper.enqueue(observable, new HttpCallback<ResumeConference>(){

                    @Override
                    public void onSuccess(@NonNull ResumeConference object, @NonNull Response<ResumeConference> response) {
                        solver.resolve((Object)object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable t, @Nullable Response<ResumeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        solver.reject(t);
                    }
                });
            }
        });
    }

    protected Promise<Boolean> onConferenceCreated(final @NonNull String conferenceId, final @NonNull String conferenceAlias, @Nullable NormalConferenceResponse other) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.createOrSetConferenceWithParams(conferenceId, conferenceAlias);
                AbstractConferenceSdkService.this.getConferenceInformation(conferenceId).setConferenceState(ConferenceState.CREATED);
                AbstractConferenceSdkService.this.getTwig().i("IConference created with id: " + AbstractConferenceSdkService.this.mConferenceId, new Object[0]);
                AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreationSuccess(conferenceId, conferenceAlias));
                AbstractConferenceSdkService.this.joinVoxeetConference(conferenceId).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Override
    public Promise<ConferenceResponse> demo() {
        return new Promise((PromiseSolver)new PromiseSolver<ConferenceResponse>(){

            public void onCall(final @NonNull Solver<ConferenceResponse> solver) {
                AbstractConferenceSdkService.this.getTwig().i("Attempting to create demo mConference", new Object[0]);
                Call<ConferenceResponse> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getCreateDemoObservable();
                HttpHelper.enqueue(user, new HttpCallback<ConferenceResponse>(){

                    @Override
                    public void onSuccess(final @NonNull ConferenceResponse object, @NonNull Response<ConferenceResponse> response) {
                        AbstractConferenceSdkService.this.onCreateDemoSuccess(object).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                            public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                                information.setConferenceType(ConferenceSimpleState.CONFERENCE);
                                solver.resolve((Object)object);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(Throwable error) {
                                solver.reject(error);
                            }
                        });
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ConferenceResponse> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e(e);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreatedError(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @NonNull
    public Promise<List<ConferenceRefreshedEvent>> inviteUserInfos(final String conferenceId, final List<UserInfo> userInfos) {
        return new Promise((PromiseSolver)new PromiseSolver<List<ConferenceRefreshedEvent>>(){

            public void onCall(@NonNull Solver<List<ConferenceRefreshedEvent>> solver) {
                List<DefaultConferenceUser> users = AbstractConferenceSdkService.this.getConferenceUsers();
                ArrayList<String> strings = new ArrayList<String>();
                if (null != userInfos) {
                    for (UserInfo info : userInfos) {
                        if (null == info || info.getExternalId() == null) continue;
                        for (int i = 0; i < users.size(); ++i) {
                            DefaultConferenceUser user = users.get(i);
                            if (null == user || null == user.getUserInfo() || !info.getExternalId().equalsIgnoreCase(user.getUserInfo().getExternalId())) continue;
                            user.updateIfNeeded(info.getName(), info.getAvatarUrl());
                        }
                        strings.add(info.getExternalId());
                    }
                }
                solver.resolve(AbstractConferenceSdkService.this.invite(conferenceId, strings));
            }
        });
    }

    @Override
    @Deprecated
    @NonNull
    public Promise<List<ConferenceRefreshedEvent>> invite(String conferenceId, List<String> ids) {
        return new InvitePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus(), conferenceId, ids).createPromise();
    }

    @Override
    public Promise<Boolean> logout() {
        return new LogoutPromise(this, this.getMediaService(), this.mConferenceObservableProvider, null, this.getEventBus()).createPromise();
    }

    @Override
    public Promise<Boolean> replay(String conferenceId, long offset) {
        return new ReplayPromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, offset).createPromise();
    }

    public Promise<Boolean> startRecording() {
        return new StartRecordingPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> stopRecording() {
        return new StopRecordingPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @Override
    public Promise<GetConferenceStatusEvent> getConferenceStatus(String conferenceId) {
        return new GetConferenceStatusPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Override
    public Promise<GetConferenceHistoryEvent> conferenceHistory(String conferenceId) {
        return new GetConferenceHistoryPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @Override
    public Promise<Boolean> switchCamera() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull((Object)AbstractConferenceSdkService.this.getMedia(), "media");
                AbstractConferenceSdkService.this.getMedia().switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                    public void onCameraSwitchDone(boolean isFrontCamera) {
                        AbstractConferenceSdkService.this.getTwig().i("Successfully switched camera", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new CameraSwitchSuccessEvent(isFrontCamera));
                        solver.resolve((Object)true);
                    }

                    public void onCameraSwitchError(String errorDescription) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to switch camera " + errorDescription, new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new CameraSwitchErrorEvent(errorDescription));
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> subscribe(@NonNull String conferenceId) {
        return new SubscribeConferenceEventPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Override
    public Promise<Boolean> unSubscribe(@NonNull String conferenceId) {
        return new UnsubscribeConferenceEventPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Override
    public Promise<Boolean> subscribeForCall(String conferenceId) {
        return new SubscribeForCallStartPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Override
    public Promise<Boolean> unSubscribeFromCall(String conferenceId) {
        return new UnsubscribeForCallStartPromiseable(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Deprecated
    @NonNull
    public Promise<Boolean> joinUsingConferenceId(@NonNull String conferenceId) {
        return this.joinVoxeetConference(conferenceId);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull SocketConnectEvent event) {
        String conferenceId = this.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != conferenceId && null != information && ConferenceState.JOINED.equals((Object)information.getConferenceState())) {
            if (this.isICERestartEnabled()) {
                Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined <3");
                Call<ResponseBody> user = this.mConferenceObservableProvider.iceRestart(conferenceId);
                HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined responded <3");
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined error </3");
                        HttpException.dumpErrorResponse(response);
                    }
                });
            } else {
                Log.d((String)TAG, (String)"onEvent: socket state opened while in conference but no isICERestartEnabled() = true. A reconnect may be longer");
            }
        } else {
            ConferenceState state = ConferenceState.DEFAULT;
            if (null != information) {
                state = information.getConferenceState();
            }
            Log.d((String)TAG, (String)("onEvent: SocketConnectEvent not rejoined </3 " + (Object)((Object)state) + " " + conferenceId));
        }
    }

    @Override
    @Deprecated
    @NonNull
    public Promise<Boolean> joinVoxeetConference(final @NonNull String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                String existingConferenceId = AbstractConferenceSdkService.this.getConferenceId();
                Log.d((String)TAG, (String)("onCall: " + AbstractConferenceSdkService.this.mInConference + " " + existingConferenceId + " " + conferenceId));
                if (AbstractConferenceSdkService.this.mInConference && (null == existingConferenceId || !existingConferenceId.equals(conferenceId))) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                AbstractConferenceSdkService.this.setIsInConference(true);
                AbstractConferenceSdkService.this.mConferenceId = conferenceId;
                ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                if (null != information) {
                    solver.resolve(AbstractConferenceSdkService.this.joinConference(information));
                } else {
                    Log.d((String)TAG, (String)"onCall: WARNING :: IMPROPER RESULT !!");
                    solver.resolve((Object)false);
                }
            }
        });
    }

    protected void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        boolean canOverride;
        String conferenceId = conference.getConference().getConferenceId();
        boolean invalidId = null == conferenceId;
        boolean inConference = this.isInConference();
        boolean sameConference = null == this.mConferenceId || this.mConferenceId.equals(conferenceId);
        boolean bl = canOverride = !inConference || sameConference;
        if (!invalidId && canOverride) {
            this.mConferenceId = conferenceId;
        }
        Log.d((String)TAG, (String)("setCurrentConferenceIfNotInPreviousConference:  invalidId = " + invalidId + " inConference = " + inConference + " sameConference = " + sameConference + " (" + this.mConferenceId + " " + conferenceId + ")  canOverride = " + canOverride + " mConferenceId = " + this.mConferenceId));
    }

    @NonNull
    protected Promise<Boolean> joinConference(final @NonNull ConferenceInformation conference) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                boolean isSuccess;
                final String conferenceId = conference.getConference().getConferenceId();
                boolean invalidId = null == conferenceId;
                boolean inConference = AbstractConferenceSdkService.this.isInConference();
                boolean sameConference = null == AbstractConferenceSdkService.this.mConferenceId || AbstractConferenceSdkService.this.mConferenceId.equals(conferenceId);
                Log.d((String)TAG, (String)("onCall: join conference " + conference + " invalidId:=" + invalidId + " inConference:=" + inConference + " sameConference:=" + sameConference + " canOverride:=" + (inConference && !sameConference)));
                if (invalidId || inConference && !sameConference) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                AbstractConferenceSdkService.this.setIsInConference(true);
                AbstractConferenceSdkService.this.mConferenceId = conferenceId;
                conference.setConferenceState(ConferenceState.JOINING);
                AudioService service = AbstractConferenceSdkService.this.mInstance.getAudioService();
                if (null != service) {
                    service.enableAec(true);
                    service.enableNoiseSuppressor(true);
                }
                if (!(isSuccess = AbstractConferenceSdkService.this.initMedia())) {
                    Log.d((String)TAG, (String)"onCall: InitMedia failed... new state = left");
                    try {
                        AbstractConferenceSdkService.this.setIsInConference(false);
                        conference.setConferenceState(ConferenceState.LEFT);
                        AbstractConferenceSdkService.this.closeMedia();
                        ConferenceJoinedError error = new ConferenceJoinedError(AbstractConferenceSdkService.this.handleError(null));
                        AbstractConferenceSdkService.this.mEventBus.post((Object)error);
                        throw new PromiseConferenceJoinedErrorException(error, null);
                    }
                    catch (PromiseConferenceJoinedErrorException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferencePreJoinedEvent(AbstractConferenceSdkService.this.getConferenceId(), AbstractConferenceSdkService.this.getAliasId()));
                Call<ResumeConference> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.joinConference(conferenceId, new JoinParameters(DeviceType.ANDROID, conference.isListener()));
                HttpHelper.enqueue(user, new HttpCallback<ResumeConference>(){

                    @Override
                    public void onSuccess(@NonNull ResumeConference object, @NonNull Response<ResumeConference> response) {
                        AbstractConferenceSdkService.this.createOrSetConferenceWithParams(object.getConferenceId(), object.getConferenceAlias());
                        AbstractConferenceSdkService.this.initMedia();
                        ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                        if (null != information) {
                            information.setConferenceState(ConferenceState.JOINED);
                        }
                        AbstractConferenceSdkService.this.onConferenceResumedInternal(object, (Solver<Boolean>)solver);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResumeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            e.printStackTrace();
                            AbstractConferenceSdkService.this.getTwig().e("Failed to Join mConference with id " + conferenceId, new Object[0]);
                            AbstractConferenceSdkService.this.setIsInConference(false);
                            conference.setConferenceState(ConferenceState.LEFT);
                            AbstractConferenceSdkService.this.closeMedia();
                            ConferenceJoinedError error = new ConferenceJoinedError(AbstractConferenceSdkService.this.handleError(e));
                            AbstractConferenceSdkService.this.mEventBus.post((Object)error);
                            throw new PromiseConferenceJoinedErrorException(error, e);
                        }
                        catch (PromiseConferenceJoinedErrorException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    protected void onConferenceResumedInternal(ResumeConference response, Solver<Boolean> solver) {
        this.mConferenceId = response.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        DefaultConference conference = information.getConference();
        conference.setConferenceId(response.getConferenceId());
        conference.setConferenceAlias(response.getConferenceId());
        if (response.getConferenceAlias() != null) {
            conference.setConferenceAlias(response.getConferenceAlias());
        }
        information.participantsToConferenceUsers(response.getParticipants());
        this.setIsInConference(true);
        this.setAudioRoute(AudioRoute.ROUTE_PHONE);
        this.getTwig().i("Joined mConference with id " + this.getConferenceId(), new Object[0]);
        this.mEventBus.post((Object)new ConferenceJoinedSuccessEvent(this.getConferenceId(), this.getAliasId()));
        solver.resolve((Object)true);
    }

    @Override
    public Promise<ConferenceUsersInvitedEvent> getInvitedUsers(@NonNull String conferenceId) {
        return new GetConferenceStatus(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Override
    @Deprecated
    public Promise<Boolean> sendBroadcastMessage(@NonNull String message) {
        return this.sendBroadcastMessage(this.getConferenceId(), message);
    }

    public Promise<Boolean> sendBroadcastMessage(@NonNull String conferenceId, @NonNull String message) {
        return new SendBroadcastMessagePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, message).createPromise();
    }

    @Override
    public Promise<Boolean> leave() {
        return new LeavePromise(this, this.getMediaService(), this.mConferenceObservableProvider, this.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceStatsEvent event) {
        ConferenceStats stats = event.getEvent();
        if (stats.getConference_id() != null && stats.getConference_id().equals(this.getConferenceId())) {
            float mos = stats.getScore(VoxeetPreferences.id());
            this.mEventBus.post((Object)new QualityIndicators(mos));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUpdatedEvent event) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceived invitation) {
        try {
            this.onEvent(invitation.getEvent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceivedEvent invitation) {
        String conferenceId = invitation.getConferenceId();
        if (null == conferenceId && null != invitation.getConference()) {
            conferenceId = invitation.getConference().getConferenceId();
        }
        Log.d((String)TAG, (String)("onEvent: current mConferenceId " + this.mConferenceId + " vs " + invitation.getConferenceId() + " vs " + conferenceId));
        if (null != this.mConferenceId && this.mConferenceId.equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for our conference, we prevent this");
            return;
        }
        final ConferenceInformation information = this.getConferenceInformation(conferenceId);
        DefaultConference conference = invitation.getConference();
        boolean is_own_user = invitation.getUserId().equals(VoxeetPreferences.id());
        ConferenceType type = ConferenceType.fromId(conference.getConferenceType());
        if (this.isLive() && null != this.getConferenceId() && this.getConferenceId().equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for the same conference, invalidate the call");
            return;
        }
        if (!is_own_user || ConferenceType.SCHEDULED.equals((Object)type)) {
            InvitationReceivedEvent.UserInviter inviter = invitation.getInviter();
            List<DefaultInvitation> invitations = invitation.getInvitations();
            if (null == information) {
                Log.d((String)TAG, (String)"onEvent: INVALID INFORMATION FOR THE CONFERENCE");
            }
            if (null != inviter && null != inviter.externalId && null != inviter.userId) {
                Log.d((String)TAG, (String)("onEvent: Invitation with inviter " + inviter.userId + " " + inviter.externalId));
                UserInfo info = this.createUserInfo(inviter.nickName, inviter.externalId, inviter.externalAvatarUrl);
                DefaultConferenceUser inviter_user = new DefaultConferenceUser(inviter.userId, "", info);
                if (null != information) {
                    information.getLastInvitationReceived().add(inviter_user);
                    information.getUserIdsCached().put(inviter.userId, inviter.externalId);
                }
            } else {
                Log.d((String)TAG, (String)"onEvent: Invitation with invalid inviter");
            }
            final String finalConferenceId = conferenceId;
            this.getConferenceStatus(conference.getConferenceId()).then((PromiseExec)new PromiseExec<GetConferenceStatusEvent, Object>(){

                public void onCall(@Nullable GetConferenceStatusEvent result, @NonNull Solver<Object> internal_solver) {
                    Log.d((String)TAG, (String)("onSuccess: " + result));
                    if (result.getConferenceUsers().size() > 0) {
                        Log.d((String)TAG, (String)("onEvent: users " + result.getConferenceUsers().size()));
                        DefaultConferenceUser foundUser = null;
                        String foundExternalId = null;
                        ArrayList<DefaultConferenceUser> merged_list = new ArrayList<DefaultConferenceUser>();
                        merged_list.addAll(result.getConferenceUsers());
                        merged_list.addAll(AbstractConferenceSdkService.this.getLastInvitationUsers());
                        Iterable list = Iterables.filter(merged_list, (Predicate)new Predicate<DefaultConferenceUser>(){

                            public boolean apply(@Nullable DefaultConferenceUser input) {
                                return !AbstractConferenceSdkService.this.currentUserOrEmpty().equals(input.getUserId());
                            }
                        });
                        for (DefaultConferenceUser conferenceUser : list) {
                            String userId = conferenceUser.getUserId();
                            if (null != foundExternalId || null == information) continue;
                            String externalId = conferenceUser.getUserInfo().getExternalId();
                            String cachedExternalId = information.getUserIdsCached().get(userId);
                            Log.d((String)TAG, (String)("onEvent: " + userId + " " + externalId + " " + cachedExternalId));
                            foundUser = conferenceUser;
                            if (null == userId || null != externalId && !userId.equals(externalId) || null == (externalId = cachedExternalId)) continue;
                            foundExternalId = cachedExternalId;
                        }
                        if (foundUser != null && null == foundExternalId) {
                            foundExternalId = foundUser.getUserId();
                            Log.d((String)TAG, (String)"externalId is null, setting it to userId");
                        }
                        HashMap<String, String> infos = new HashMap<String, String>();
                        if (null != foundUser) {
                            // empty if block
                        }
                        infos.put("UserId", null != foundUser ? foundUser.getUserId() : "");
                        infos.put("DisplayName", null != foundUser ? foundUser.getUserInfo().getName() : "");
                        infos.put("NotifType", null != result.getType() ? result.getType() : "");
                        infos.put("ExternalId", null != foundUser ? foundExternalId : "");
                        infos.put("AvatarUrl", null != foundUser ? foundUser.getUserInfo().getAvatarUrl() : "");
                        infos.put("ConfId", null != result.getConferenceId() ? result.getConferenceId() : "");
                        AbstractConferenceSdkService.this.getTwig().i("Starting default incoming view " + finalConferenceId + " " + result.getConferenceId(), new Object[0]);
                        Intent intent = VoxeetIntentFactory.buildFrom(AbstractConferenceSdkService.this.mContext, VoxeetPreferences.getDefaultActivity(), infos);
                        if (intent != null) {
                            AbstractConferenceSdkService.this.mContext.startActivity(intent);
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new IncomingCallEvent());
                    }
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceStartedEvent ownConferenceStartedEvent) {
        if (null != ownConferenceStartedEvent.event().getConferenceInfos()) {
            this.mConferenceId = ownConferenceStartedEvent.event().getConferenceInfos().getConferenceId();
        }
        DefaultConference conference = this.getConference();
        this.getTwig().i("Own mConference started :: " + this.mConferenceId + " " + conference, new Object[0]);
        if (null != conference) {
            conference.setConferenceInfos(ownConferenceStartedEvent.event().getConferenceInfos());
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(StartVideoAnswerEvent event) {
        Log.d((String)TAG, (String)("onEvent: start video event " + event.isSuccess() + " " + event.message()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RenegociationUpdate event) {
        RenegociationEndedEvent renego = event.getEvent();
        Log.d((String)TAG, (String)("onEvent: Renegociation " + renego.getConferenceId() + " " + renego.getType() + " " + renego.getAnswerReceived() + " " + renego.getOfferSent()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(final OfferCreatedEvent event) {
        Log.d((String)TAG, (String)("onEvent: OfferCreatedEvent " + event.message()));
        try {
            this.handleAnswer(event.offer()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + event.offer().getUserId() + " " + VoxeetPreferences.id()));
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }
        catch (MediaEngineException e) {
            e.printStackTrace();
            this.getTwig().e(e);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserAddedEvent event) {
        if (!this.mConferenceId.equals(event.getEvent().getConferenceId())) {
            Log.d((String)TAG, (String)"onEvent: USER ADDED FOR ANOTHER CONFERENCE");
        }
        DefaultConference conference = this.getOrSetConference(event.getEvent().getConferenceId());
        ConferenceUserAdded content = event.getEvent();
        if (null != content) {
            HashMap<String, MediaStream> streams;
            Log.d((String)TAG, (String)("onEvent: ParticipantAdded " + content + " " + content.getUserId() + " " + conference.getConferenceUsers().size()));
            DefaultConferenceUser user = this.findUserById(content.getUserId());
            if (null == user) {
                user = new DefaultConferenceUser(content.getUserId(), null);
                user.setIsOwner(false);
                user.setUserInfo(new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
                conference.getConferenceUsers().add(user);
            }
            if (null == user.getUserInfo()) {
                Log.d((String)TAG, (String)"onEvent: existing user info are invalid, refreshing");
                user.setUserInfo(new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
            }
            user.updateIfNeeded(content.getName(), content.getAvatarUrl());
            ConferenceUserStatus status = ConferenceUserStatus.fromString((String)content.getStatus());
            if (null != status) {
                user.setConferenceStatus(status);
                user.setStatus(content.getStatus());
            }
            this.mTwig.i("from Event ConferenceUserAddedEvent, user joined with id := " + user.getUserId() + " " + (user.getUserInfo() != null ? user.getUserInfo().getExternalId() : "no external id"), new Object[0]);
            MediaStream stream = null;
            if (this.hasMedia() && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                stream = streams.get(user.getUserId());
            }
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdatedEvent event) {
        boolean timeout_managed;
        DefaultConferenceUser user = this.findUserById(event.getUserId());
        ConferenceUserStatus status = ConferenceUserStatus.valueOf((String)event.getStatus());
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setStatus(event.getStatus());
            this.commitTransactionConferenceUser();
        } else {
            this.getTwig().i("Not in mConference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
        }
        this.updateConferenceFromUsers();
        switch (status) {
            case CONNECTING: {
                if (null == user || user.getUserId().equals(VoxeetPreferences.id())) break;
                this.mTwig.i("Cancelling timeout timer from user connecting", new Object[0]);
                this.removeTimeoutCallbacks();
                break;
            }
            case LEFT: 
            case DECLINE: {
                if (!this.hasMedia() || user == null) break;
                this.getTwig().i("In mConference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
                this.getMedia().removePeer(event.getUserId());
                break;
            }
            default: {
                this.getTwig().i("status not managed updated to " + event.getStatus(), new Object[0]);
            }
        }
        boolean bl = timeout_managed = this.timeoutRunnable != null && this.timeoutRunnable.isTriggered();
        if (!timeout_managed) {
            switch (status) {
                case DECLINE: {
                    if (event.getUserId().equals(VoxeetPreferences.id())) break;
                    this.getTwig().i("Conference user with id: " + event.getUserId() + " declined the call", new Object[0]);
                    this.mEventBus.post((Object)new ConferenceUserCallDeclinedEvent(event.getConfId(), event.getUserId(), event.getStatus()));
                    break;
                }
                case LEFT: {
                    this.onUserLeft(event.getUserId());
                    break;
                }
                default: {
                    HashMap<String, MediaStream> streams;
                    MediaStream stream = null;
                    if (this.hasMedia() && null != user && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                        stream = streams.get(user.getUserId());
                    }
                    if (null == user) break;
                    this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                }
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantAddedEvent event) {
        DefaultConferenceUser user = event.getUser();
        if (user != null) {
            HashMap<String, MediaStream> streams;
            this.mTwig.i("Conference user joined with id: " + user.getUserId(), new Object[0]);
            MediaStream stream = null;
            if (this.hasMedia() && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                stream = streams.get(user.getUserId());
            }
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPushEvent event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.getPush().getConferenceId())) {
            this.closeMedia();
            this.getTwig().i("Conference has ended", new Object[0]);
            this.mEventBus.post((Object)event.getPush());
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceEndedEvent event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.getEvent().getConferenceId())) {
            this.closeMedia();
            this.getTwig().i("Conference has ended", new Object[0]);
            this.mEventBus.post((Object)event.getEvent());
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdatedEvent event) {
        for (DefaultConferenceUser conferenceUser : event.getEvent().getUser()) {
            DefaultConferenceUser user = this.findUserById(conferenceUser.getUserId());
            if (user == null) continue;
            this.mTwig.i("Quality updated for " + user.getUserId(), new Object[0]);
            this.startTransactionConferenceUser();
            user.setQuality(conferenceUser.getQuality());
            this.commitTransactionConferenceUser();
            this.mEventBus.post((Object)new ConferenceUserQualityUpdatedEvent(user));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RecordingStatusUpdate event) {
        String conferenceId = event.getEvent().getConferenceId();
        Log.d((String)TAG, (String)("onEvent: eevnt for " + conferenceId));
        DefaultConference conference = this.getConferenceInformation(conferenceId).getConference();
        RecordingStatusUpdateEvent recordingStatusUpdateEvent = event.getEvent();
        DefaultConferenceUser user = this.findUserById(recordingStatusUpdateEvent.getUserId());
        if (user != null) {
            RecordingStatus status = RecordingStatus.valueOf((String)recordingStatusUpdateEvent.getRecordingStatus());
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                conference.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.getTimeStamp()));
                conference.setRecordingStatus(RecordingStatus.RECORDING);
                conference.setRecordingUser(recordingStatusUpdateEvent.getUserId());
                user.setIsRecordingOwner(true);
            } else {
                this.isRecording = false;
                conference.setStartRecordTimestamp(null);
                conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                conference.setRecordingUser(null);
                user.setIsRecordingOwner(false);
            }
        }
        this.getTwig().i("Conference's recording status has changed to: " + event.getEvent().getRecordingStatus(), new Object[0]);
        this.mEventBus.post((Object)recordingStatusUpdateEvent);
    }

    protected abstract DefaultConference createConference();

    protected abstract DefaultConferenceUser createConferenceUser(String var1, String var2, UserInfo var3);

    protected abstract UserInfo createUserInfo(String var1, String var2, String var3);

    protected Twig getTwig() {
        return this.mTwig;
    }

    protected void setConference(@NonNull DefaultConference conference) {
        this.mConferenceId = conference.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        information.setConference(conference);
    }

    protected void setConferenceAlias(String alias) {
        DefaultConference conference = this.getConference();
        conference.setConferenceAlias(alias);
    }

    @Override
    public EventBus getEventBus() {
        return this.mEventBus;
    }

    protected ConferenceListener getConferenceListener() {
        return this.mListener;
    }

    protected MediaSDK getMedia() {
        return this.getMediaService().getMedia();
    }

    protected abstract void startTransactionConferenceUser();

    protected abstract void commitTransactionConferenceUser();

    protected abstract boolean isSDK();

    protected Promise<Integer> answer(final String peer, final SdpMessage message) {
        return new Promise((PromiseSolver)new PromiseSolver<Integer>(){

            public void onCall(final @NonNull Solver<Integer> solver) {
                try {
                    if (null == AbstractConferenceSdkService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
                Log.d((String)"SDKMEDIA", (String)("answer: peer := " + peer + " message := " + message));
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.answerConference(AbstractConferenceSdkService.this.mConferenceId, peer, message.getDescription());
                HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        if (response.code() != 200) {
                            AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : KO", new Object[0]);
                            try {
                                ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(response.code() + "");
                                throw new PromiseParticipantAddedErrorEventException(event);
                            }
                            catch (PromiseParticipantAddedErrorEventException exception) {
                                solver.reject((Throwable)exception);
                            }
                        } else {
                            AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : OK", new Object[0]);
                            solver.resolve((Object)response.code());
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().e("Offer created for " + peer + " : KO", new Object[0]);
                        HttpException.dumpErrorResponse(response);
                        try {
                            ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(AbstractConferenceSdkService.this.handleError(e));
                            throw new PromiseParticipantAddedErrorEventException(event);
                        }
                        catch (PromiseParticipantAddedErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    protected Promise<Boolean> handleAnswer(final OfferCreated offer) throws MediaEngineException {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                String conferenceId;
                if (!AbstractConferenceSdkService.this.hasMedia()) {
                    try {
                        throw new MediaEngineException("handleAnswer media is null");
                    }
                    catch (MediaEngineException exception) {
                        solver.reject((Throwable)exception);
                    }
                }
                if (!(conferenceId = offer.getConferenceId()).equals(AbstractConferenceSdkService.this.mConferenceId)) {
                    Log.d((String)TAG, (String)"onCall: CONFERENCE IS NOT THE SAME ! ANSWER SHALL BE DISCARDED");
                }
                SdpDescription description = new SdpDescription(offer.getDescription().getType(), offer.getDescription().getSdp());
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                for (OfferCandidate candidate : offer.getCandidates()) {
                    Log.d((String)TAG, (String)("onCall: sdpcandidate " + candidate.getMid() + " " + candidate.getmLine()));
                    candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                }
                String userId = offer.getUserId();
                Log.d((String)TAG, (String)("handleAnswer: offer := " + offer.getUserId() + " " + offer.getExternalId()));
                Log.d((String)"SDKMEDIA", (String)("handleAnswer: " + offer.getUserId() + " " + offer.getExternalId() + " " + description.getSsrc()));
                try {
                    AbstractConferenceSdkService.this.getMedia().createAnswerForPeer(userId, description.getSsrc(), description, candidates, offer.isMaster(), new PendingPeerCallback(){

                        @Override
                        public void onMessage(@Nullable SdpMessage message) {
                            try {
                                if (null == AbstractConferenceSdkService.this.mConferenceId) {
                                    Log.d((String)TAG, (String)"onMessage: INVALID CONFERENCE ID WHEN OFFER IS RECEIVED");
                                    AbstractConferenceSdkService.this.mConferenceId = offer.getConferenceId();
                                }
                                DefaultConference conference = AbstractConferenceSdkService.this.getConference();
                                DefaultConferenceUser user = null;
                                for (DefaultConferenceUser in_conf : conference.getConferenceUsers()) {
                                    if (in_conf.getUserId() == null || !in_conf.getUserId().equals(offer.getUserId())) continue;
                                    user = in_conf;
                                }
                                UserInfo infos = offer.getUserId().contains("11111") ? AbstractConferenceSdkService.this.createUserInfo("Julie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_1.png") : (offer.getUserId().contains("22222") ? AbstractConferenceSdkService.this.createUserInfo("Sophie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_2.png") : (offer.getUserId().contains("33333") ? AbstractConferenceSdkService.this.createUserInfo("Mike", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_3.png") : AbstractConferenceSdkService.this.createUserInfo(offer.getName(), offer.getExternalId(), offer.getAvatarUrl())));
                                if (user == null) {
                                    user = AbstractConferenceSdkService.this.createConferenceUser(offer.getUserId(), offer.getDevice(), infos);
                                    conference.getConferenceUsers().add(user);
                                } else {
                                    user.setUserInfo(infos);
                                }
                                AbstractConferenceSdkService.this.setUserPosition(offer.getUserId(), 0.0, 0.5);
                                AbstractConferenceSdkService.this.answer(offer.getUserId(), message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                    public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                        Log.d((String)TAG, (String)("onSuccess: " + result));
                                        solver.resolve((Object)true);
                                    }
                                }).error(new ErrorPromise(){

                                    public void onError(Throwable error) {
                                        if (error instanceof PromiseParticipantAddedErrorEventException) {
                                            AbstractConferenceSdkService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                        } else {
                                            error.printStackTrace();
                                        }
                                        solver.resolve((Object)false);
                                    }
                                });
                            }
                            catch (Exception e) {
                                Log.d((String)TAG, (String)("onMessage: unlockPeerOperation" + e.getMessage()));
                                solver.resolve((Object)false);
                            }
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    protected DefaultConferenceUser updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        DefaultConferenceUser user = this.findUserById(userId);
        DefaultConference conference = this.getConference();
        if (null != user && null != conference) {
            this.startTransactionConferenceUser();
            user.setIsOwner(conference.getOwnerProfile() == null || conference.getOwnerProfile().getUserId().equals(user.getProfile().getUserId())).setConferenceStatus(status).setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
            this.commitTransactionConferenceUser();
            return user;
        }
        return null;
    }

    protected boolean initMedia() {
        Validate.notNull(this.mContext, "mContext");
        Validate.notNull(VoxeetPreferences.id(), "user id");
        if (!this.hasMedia()) {
            try {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getTwig().i("the app does not seem to have mic permission, disabling mic", new Object[0]);
                    this.mute(true);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                this.getAudioService().enable();
                this.getMediaService().createMedia(this.context, VoxeetPreferences.id(), this.mediaStreamListener, this.cameraEventsHandler, this.isVideoOn(), Validate.hasMicrophonePermissions(this.context));
                this.getAudioService().setSpeakerMode(this.isDefaultOnSpeaker);
                this.getAudioService().requestAudioFocus();
                if (this.isDefaultMute) {
                    this.getMedia().mute();
                } else {
                    this.getMedia().unMute();
                }
            }
            catch (MediaEngineException e) {
                this.getTwig().e(e);
            }
        }
        return true;
    }

    protected void closeMedia() {
        if (this.hasMedia()) {
            MediaSDK media = this.getMedia();
            DefaultConference conference = this.getConference();
            ConferenceInformation information = this.getCurrentConferenceInformation();
            if (null != information) {
                information.setOwnVideoStarted(false);
                information.setScreenShareOn(false);
            }
            try {
                if (null != conference) {
                    for (DefaultConferenceUser user : conference.getConferenceUsers()) {
                        if (user == null || user.getUserId() == null) continue;
                        media.removePeer(user.getUserId());
                    }
                }
            }
            catch (Exception ex) {
                this.mTwig.e(ex);
            }
            this.getAudioService().abandonAudioFocusRequest();
            this.getAudioService().disable();
            this.getMediaService().releaseMedia();
            this.getTwig().i("Microphone value restored to true", new Object[0]);
            this.mTwig.i("Video value restored to false", new Object[0]);
            this.getTwig().i("Listener mode set back to false", new Object[0]);
        }
        this.getTwig().i("Media closed", new Object[0]);
        this.setIsInConference(false);
        this.mConferenceId = null;
    }

    protected void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    protected void sendTimeoutCallbacks() {
        if (this.mTimeOutTimer != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.getTwig(), this.mEventBus, this.mTimeOutTimer);
            this.getTwig().i("scheduling timer to leave the mConference in " + this.mTimeOutTimer, new Object[0]);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.mTimeOutTimer);
        }
    }

    private void onUserLeft(@NonNull String peer) {
        DefaultConferenceUser user = this.findUserById(peer);
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setConferenceStatus(ConferenceUserStatus.LEFT);
            if (this.getConferenceUsers().contains(user)) {
                this.getConferenceUsers().remove(user);
            }
            this.getTwig().i("Conference user left with id: " + user.getUserId(), new Object[0]);
            this.commitTransactionConferenceUser();
            if (this.mapOfStreams.containsKey(user.getUserId())) {
                this.mapOfStreams.remove(user.getUserId());
            }
            if (this.mapOfScreenShareStreams.containsKey(user.getUserId())) {
                this.mapOfScreenShareStreams.remove(user.getUserId());
            }
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserLeftEvent(user));
        } else {
            Log.d((String)TAG, (String)"run: unknown user in stream left");
        }
    }

    protected VoxeetSdkTemplate getVoxeetSDK() {
        return this.mSDK;
    }

    private AudioService getAudioService() {
        return this.getVoxeetSDK().getAudioService();
    }

    @NonNull
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        Log.d((String)TAG, (String)("createOrSetConferenceWithParams: set conference id := " + conferenceId));
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        DefaultConference conference = information.getConference();
        conference.setConferenceId(conferenceId);
        if (null != conferenceAlias || null == conference.getConferenceAlias()) {
            conference.setConferenceAlias(conferenceAlias);
        }
        return information;
    }

    @Nullable
    public ConferenceInformation getCurrentConferenceInformation() {
        return this.getConferenceInformation(this.mConferenceId);
    }

    @Nullable
    protected ConferenceInformation getConferenceInformation(@Nullable String conferenceId) {
        if (null == conferenceId) {
            return null;
        }
        return this.mConferenceInformationHolder.getInformation(conferenceId);
    }

    private void updateConferenceFromUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != information) {
            ConferenceState state = information.getState();
            switch (state) {
                case JOINED: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
                case FIRST_PARTICIPANT: {
                    if (this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.NO_MORE_PARTICIPANT);
                    break;
                }
                case NO_MORE_PARTICIPANT: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
            }
            ConferenceState conferenceState = information.getState();
        }
    }

    public boolean hasParticipants() {
        List<DefaultConferenceUser> users = this.getConferenceUsers();
        for (DefaultConferenceUser user : users) {
            ConferenceUserStatus status = user.getConferenceStatus();
            if (null == user.getUserId() || user.getUserId().equals(VoxeetPreferences.id()) || !ConferenceUserStatus.ON_AIR.equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    public void setICERestartEnabled(boolean new_state) {
        this.isICERestartEnabled = new_state;
    }

    public boolean isICERestartEnabled() {
        return this.isICERestartEnabled;
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @Nullable
    public String getDefaultCamera() {
        return this.mDefaultCamera;
    }

    private boolean hasMedia() {
        return null != this.getMedia();
    }

    @NonNull
    private MediaService getMediaService() {
        return this.mInstance.getMediaService();
    }

    protected void joinLock() {
        try {
            this.joinLock.lock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void joinUnlock() {
        try {
            if (this.joinLock.isLocked()) {
                this.joinLock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

