package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.greenrobot.eventbus.EventBus;

import java.io.IOException;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.promises.NotInConferenceException;
import voxeet.com.sdk.events.success.StopRecordingResultEvent;

public class StopRecordingPromiseable extends AbstractPromiseable<Boolean> {

    public StopRecordingPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                try {
                    ConferenceInformation information = getInformation();
                    if (null == information || null == information.getConference().getConferenceId()) {
                        throw new NotInConferenceException();
                    }

                    final Call<ResponseBody> user = getProvider().getStopRecordingObservable(information.getConference().getConferenceId());
                    HttpHelper.enqueue(user, new HttpCallback<ResponseBody>() {
                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200)
                                log("Conference recording stopped");

                            try {
                                log("onNext: " + response.body().string());
                            } catch (IOException e) {
                                e.printStackTrace();
                            }

                            getEventBus().post(new StopRecordingResultEvent(response.code() == 200));
                            solver.resolve(response.code() == 200);
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);

                            log("Failed to cancel mConference recording");

                            getEventBus().post(new StopRecordingResultEvent(getParent().handleError(e), false));
                            solver.reject(e);
                        }
                    });
                } catch (Throwable e) {
                    e.printStackTrace();
                    solver.reject(e);
                }
            }
        });
    }
}
