package voxeet.com.sdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

/**
 * Created by kevinleperf on 26/10/2018.
 */

public final class AndroidManifest {

    private static final String TAG = AndroidManifest.class.getSimpleName();

    private AndroidManifest() {

    }

    public static int readMetadataInt(@NonNull Context context, @NonNull String key, int argb) {
        try {
            String metaData = readMetadata(context, key, null);
            if (!TextUtils.isEmpty(metaData)) return Integer.parseInt(metaData);
        } catch (Exception e) {

        }
        return argb;
    }

    public static String readMetadata(@NonNull Context context, @NonNull String key, @NonNull String def) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(),
                    PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;
            String value = "";
            if(bundle.containsKey(key)) {
                Object object = bundle.get(key);
                if(null != object) {
                    if (object instanceof Integer) {
                        int resource = bundle.getInt(key);
                        value = context.getString(resource);
                    } else if(object instanceof  String) {
                        value = (String) object;
                    }
                }
            }
            if (!TextUtils.isEmpty(value)) return value;
        } catch (PackageManager.NameNotFoundException e) {
            String message = e.getMessage();
            if (null != message) {
                Log.d(TAG, "readMetadata: " + e.getMessage());
            }
        }
        return def;
    }
}
