package voxeet.com.sdk.core.network;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;
import voxeet.com.sdk.events.success.GetUserProfileSuccessEvent;
import voxeet.com.sdk.events.success.LoginSuccessResponseEvent;
import voxeet.com.sdk.events.success.OwnProfileSuccessEvent;
import voxeet.com.sdk.json.EmailEvent;
import voxeet.com.sdk.json.LoginEvent;
import voxeet.com.sdk.json.ResendActivationEvent;
import voxeet.com.sdk.json.ResetPasswordEvent;
import voxeet.com.sdk.json.SignUpEvent;
import voxeet.com.sdk.json.SocialLoginEvent;
import voxeet.com.sdk.json.UpdatePasswordEvent;
import voxeet.com.sdk.json.UpdatePresenceEvent;
import voxeet.com.sdk.json.UpdateProfileEvent;

/**
 * Created by ROMMM on 4/4/16.
 */
public interface IUserRService {

    @POST("users/login")
    Call<LoginSuccessResponseEvent> login(@Body LoginEvent loginEvent);

    @POST("mobile/loginValidated")
    Call<LoginSuccessResponseEvent> socialLogin(@Body SocialLoginEvent loginEvent);

    @POST("users/logout")
    Call<ResponseBody> logout();

    @POST("users/resetPassword")
    Call<ResponseBody> resetPassword(@Body ResetPasswordEvent event);

    @POST("users/create")
    Call<ResponseBody> signup(@Body SignUpEvent event);

    @PUT("users/me")
    Call<ResponseBody> updateProfile(@Body UpdateProfileEvent event);

    @PUT("users/me/updatePresence")
    Call<ResponseBody> updatePresence(@Body UpdatePresenceEvent event);

    @GET("users/me")
    @Headers("Content-Type: application/json")
    Call<OwnProfileSuccessEvent> getOwnProfile();

    @GET("users/me/getUploadToken")
    @Headers("Content-Type: application/json")
    Call<GetTokenUploadSuccessEvent> getUploadToken();

    @GET("users/{userId}")
    Call<GetUserProfileSuccessEvent> getUserProfile(@Path("userId") String userId);

    @POST("users/resendActivation")
    Call<ResponseBody> resendActivation(@Body ResendActivationEvent event);

    @POST("users/resendValidation")
    Call<ResponseBody> resendValidation(@Body ResendActivationEvent event);

    @PUT("users/me/addEmail")
    Call<ResponseBody> addEmail(@Body EmailEvent event);

    @PUT("users/me/removeEmail")
    Call<ResponseBody> removeEmail(@Body EmailEvent event);

    @PUT("users/me/setDefaultEmail")
    Call<ResponseBody> setDefaultEmail(@Body EmailEvent event);

    @PUT("/users/me/updatePassword")
    Call<ResponseBody> updatePassword(@Body UpdatePasswordEvent event);
}