/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.audio;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import java.util.ArrayList;
import java.util.List;

public class MessagingEnvironment {
    static final int DEFAILT_CONNECTION_TIMEOUT = 15000;
    static final int DEFAULT_KEEP_ALIVE_INTERVAL = 30000;
    static final int DEFAULT_RECONNECTION_DELAY = 1500;
    static final int DEFAULT_RECONNECTION_LIMIT = 60000;
    static final int DEFAULT_MAX_RECONNECTION_ATTEMPTS = 5;
    private List<String> mServerHosts = new ArrayList<String>();
    private int mServerPort;
    private String mStunHost;
    private int mStunPort;
    private int mConnectionTimeout = 15000;
    private int mSearchPageSize;
    private int mKeepAliveInterval = 30000;
    private int mReconnectionDelay = 1500;
    private int mReconnectionLimit = 60000;
    private int mMaxReconnectionAttempts = 5;

    private MessagingEnvironment() {
    }

    public int getReconnectionDelay() {
        return this.mReconnectionDelay;
    }

    public int getReconnectionLimit() {
        return this.mReconnectionLimit;
    }

    public int getMaxReconnectionAttempts() {
        return this.mMaxReconnectionAttempts;
    }

    public List<String> getServerHosts() {
        return this.mServerHosts;
    }

    public void addServerHost(String address) {
        this.mServerHosts.add(address);
    }

    public int getServerPort() {
        return this.mServerPort;
    }

    public void setServerPort(int serverPort) {
        this.mServerPort = serverPort;
    }

    public void setStunHost(String stunHost) {
        this.mStunHost = stunHost;
    }

    public String getStunHost() {
        return this.mStunHost;
    }

    public void setStunPort(int stunPort) {
        this.mStunPort = stunPort;
    }

    public int getStunPort() {
        return this.mStunPort;
    }

    public int getConnectionTimeout() {
        return this.mConnectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.mConnectionTimeout = connectionTimeout;
    }

    public int getSearchPageSize() {
        return this.mSearchPageSize;
    }

    public void setSearchPageSize(int searchPageSize) {
        this.mSearchPageSize = searchPageSize;
    }

    public int getKeepAliveInterval() {
        return this.mKeepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.mKeepAliveInterval = keepAliveInterval;
    }

    public static class Builder {
        private Context _context;
        private MessagingEnvironment _messaging_environment = new MessagingEnvironment();

        private Builder() {
        }

        public Builder(@NonNull Context context) {
            this();
            this._context = context;
        }

        public Builder setServerHost(@StringRes int host) {
            this._messaging_environment.addServerHost(this._context.getString(host));
            return this;
        }

        public Builder setServerPort(@StringRes int port) {
            int server_port = Integer.parseInt(this._context.getString(port));
            this._messaging_environment.setServerPort(server_port);
            return this;
        }

        public Builder setStunHost(@StringRes int stun_host) {
            this._messaging_environment.setStunHost(this._context.getString(stun_host));
            return this;
        }

        public Builder setStunPort(@StringRes int stun_port) {
            int stun_server_port = Integer.parseInt(this._context.getString(stun_port));
            this._messaging_environment.setStunPort(stun_server_port);
            return this;
        }

        public MessagingEnvironment build() {
            return this._messaging_environment;
        }
    }
}

