/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services.authenticate;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import voxeet.com.sdk.core.http.RefreshTokenBody;
import voxeet.com.sdk.core.services.authenticate.token.TokenResponseProvider;
import voxeet.com.sdk.json.GrandTypeEvent;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.utils.AbstractVoxeetEnvironmentHolder;
import voxeet.com.sdk.utils.Auth64;

public class KeySecretTokenResponseProvider
extends TokenResponseProvider {
    @NonNull
    private String appId = "";
    @NonNull
    private String secret = "";

    private KeySecretTokenResponseProvider(@NonNull AbstractVoxeetEnvironmentHolder holder) {
        super(holder);
    }

    public KeySecretTokenResponseProvider(@NonNull String appId, @NonNull String secret, @NonNull AbstractVoxeetEnvironmentHolder holder) {
        this(holder);
        this.appId = appId;
        this.secret = secret;
    }

    @Override
    @Nullable
    public TokenResponse refreshTokenResponse() {
        Log.d((String)this.TAG, (String)"refreshTokenResponse: calling refreshing token");
        TokenResponse previous = this.tokenResponse;
        TokenResponse new_token_response = null;
        Call<TokenResponse> token = null;
        String tokenizedCredentials = Auth64.serialize(this.appId, this.secret);
        try {
            if (null != previous && null != previous.getRefreshToken()) {
                token = this.service.refreshToken(tokenizedCredentials, new RefreshTokenBody(previous.getRefreshToken()));
            }
            if (null != token) {
                new_token_response = (TokenResponse)token.execute().body();
            }
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)("authenticate: error on refresh token " + e.getMessage()));
            e.printStackTrace();
        }
        if (null != new_token_response && null != new_token_response.getAccessToken()) {
            return new_token_response;
        }
        try {
            token = this.service.getToken(tokenizedCredentials, new GrandTypeEvent("client_credentials"));
            return (TokenResponse)token.execute().body();
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)"refreshTokenResponse: second token attempt error");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @NonNull
    protected Promise<TokenResponse> retrieveTokenResponse() {
        return new Promise((PromiseSolver)new PromiseSolver<TokenResponse>(){

            public void onCall(final @NonNull Solver<TokenResponse> solver) {
                Call<TokenResponse> token = KeySecretTokenResponseProvider.this.service.getToken(Auth64.serialize(KeySecretTokenResponseProvider.this.appId, KeySecretTokenResponseProvider.this.secret), new GrandTypeEvent("client_credentials"));
                token.enqueue((Callback)new Callback<TokenResponse>(){

                    public void onResponse(Call<TokenResponse> call, Response<TokenResponse> response) {
                        Log.d((String)KeySecretTokenResponseProvider.this.TAG, (String)("onResponse: " + response.body()));
                        solver.resolve(response.body());
                    }

                    public void onFailure(Call<TokenResponse> call, Throwable t) {
                        Log.d((String)KeySecretTokenResponseProvider.this.TAG, (String)("onFailure: " + t));
                        t.printStackTrace();
                        solver.reject(t);
                    }
                });
            }
        });
    }

    @Override
    @NonNull
    protected Request.Builder addHeader(@NonNull Request.Builder builder) {
        return builder.addHeader("Authorization", Auth64.serialize(this.appId, this.secret));
    }
}

