/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.audio;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.audio.AudioRoute;
import java.util.HashMap;
import java.util.List;
import voxeet.com.sdk.utils.AudioType;
import voxeet.com.sdk.utils.SoundPool;
import voxeet.com.sdk.utils.Validate;

public class SoundManager {
    private com.voxeet.android.media.audio.AudioManager mAudioManager;
    private MediaPowerManager mMediaPowerManager;
    private Context mContext;
    private AudioManager mSystemAudioService;
    private int mSoundMode;
    private SoundPool _sound_pool;
    private HashMap<AudioType, String> mSounds;
    private boolean mEnable;

    private SoundManager() {
        this.enable();
    }

    public SoundManager(@NonNull Context context) {
        this();
        this.mSoundMode = 0;
        this.mAudioManager = new com.voxeet.android.media.audio.AudioManager(context);
        this.mMediaPowerManager = new MediaPowerManager(context, this.currentRoute());
        this.mContext = context;
        this.mSystemAudioService = (AudioManager)this.mContext.getSystemService("audio");
        this.mSounds = new HashMap();
        this.configure();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return this.mAudioManager.availableRoutes();
    }

    public AudioRoute currentRoute() {
        return this.mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        if (this.isWiredHeadsetOn()) {
            route = AudioRoute.ROUTE_HEADSET;
        } else if (this.isBluetoothHeadsetConnected()) {
            route = AudioRoute.ROUTE_BLUETOOTH;
        }
        return this.mAudioManager.setOutputRoute(route);
    }

    public boolean isBluetoothHeadsetConnected() {
        return this.mAudioManager.isBluetoothHeadsetConnected();
    }

    public boolean isWiredHeadsetOn() {
        return this.mAudioManager.isWiredHeadsetOn();
    }

    public SoundManager setSpeakerMode(boolean isSpeaker) {
        this.mAudioManager.setSpeakerMode(isSpeaker);
        return this;
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals((Object)this.mAudioManager.outputRoute());
    }

    public SoundManager acquireLocks() {
        this.mMediaPowerManager.acquire();
        return this;
    }

    public SoundManager releaseLocks() {
        this.mMediaPowerManager.release();
        return this;
    }

    public SoundManager setInVoiceCallSoundType() {
        this.mAudioManager.forceVolumeControlStream(this.mSoundMode);
        return this;
    }

    public SoundManager resetDefaultSoundType() {
        this.mAudioManager.resetDefaultSoundType();
        return this;
    }

    private int getUiSoundsStreamType() {
        return this.mAudioManager.getDefaultSoundStreamType();
    }

    private SoundManager forceVolumeControlStream(int type) {
        this.mAudioManager.forceVolumeControlStream(type);
        return this;
    }

    public SoundManager abandonAudioFocusRequest() {
        this.mAudioManager.abandonAudioFocusRequest();
        return this;
    }

    public SoundManager requestAudioFocus() {
        this.mAudioManager.requestAudioFocus();
        return this;
    }

    private SoundPool getSoundPool() {
        if (this._sound_pool == null) {
            this._sound_pool = new SoundPool(this.mContext, this.mSoundMode);
        }
        return this._sound_pool;
    }

    private void configure() {
        this.mSounds.put(AudioType.RING, "out.mp3");
        this.mSounds.put(AudioType.HANGUP, "leave.mp3");
        this.setSound(AudioType.RING, this.mSounds.get((Object)AudioType.RING));
        this.setSound(AudioType.HANGUP, this.mSounds.get((Object)AudioType.HANGUP));
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return this.getSoundPool().release(type).setShortResource(type, assetName);
    }

    public SoundManager playSoundType(@NonNull AudioType type) {
        if (this.isEnabled()) {
            this.getSoundPool().playShortResource(type, this.mSounds.get((Object)type));
        }
        return this;
    }

    public SoundManager playSoundTypeForce(@NonNull AudioType type) {
        this.getSoundPool().playShortResource(type, this.mSounds.get((Object)type));
        return this;
    }

    public SoundManager stopSoundType(@NonNull AudioType audioType) {
        this.getSoundPool().stop(audioType);
        return this;
    }

    public SoundManager stop() {
        this.getSoundPool().stop();
        return this;
    }

    public SoundManager onConferencePreJoinedEvent() {
        this.mAudioManager.checkOutputRoute();
        return this;
    }

    public SoundManager onConferenceDestroyedPush() {
        this.abandonAudioFocusRequest();
        return this;
    }

    public void enable() {
        this.mEnable = true;
    }

    public void disable() {
        this.mEnable = false;
    }

    private boolean isEnabled() {
        return this.mEnable;
    }
}

